<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Patient extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Patientmodel');
    }

    public function AddPatient()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['Name'] = $this->input->post('Name', TRUE);
            $inputData['Age'] = $this->input->post('Age', TRUE);
            $inputData['Gender'] = $this->input->post('Gender', TRUE);
            $inputData['Mobile'] = $this->input->post('Mobile', TRUE);
            //    $inputData['MaritalStatus'] = $this->input->post('MaritalStatus', TRUE);
            //    $inputData['Occupation'] = $this->input->post('Occupation', TRUE);
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $inputData['Data'] = $this->input->post('Data', TRUE);
            $inputData['AlternateMobile'] = $this->input->post('AlternateMobile', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['Name'] && isset($input_data['Name'])) {
                $inputData['Name'] = $input_data['Name'];
            }
            if (!$inputData['Age'] && isset($input_data['Age'])) {
                $inputData['Age'] = $input_data['Age'];
            }
            if (!$inputData['Gender'] && isset($input_data['Gender'])) {
                $inputData['Gender'] = $input_data['Gender'];
            }
            if (!$inputData['Mobile'] && isset($input_data['Mobile'])) {
                $inputData['Mobile'] = $input_data['Mobile'];
            }
            if (!$inputData['AlternateMobile'] && isset($input_data['AlternateMobile'])) {
                $inputData['AlternateMobile'] = $input_data['AlternateMobile'];
            }
            /* if (!$inputData['Occupation'] && isset($input_data['Occupation'])) {
              $inputData['Occupation'] = $input_data['Occupation'];
              }
             * 
             */
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }
            if (!$inputData['Data'] && isset($input_data['Data'])) {
                $inputData['Data'] = $input_data['Data'];
            }

            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['UserId']) && !empty($inputData['Name']) && !empty($inputData['Age']) && !empty($inputData['Gender']) && !empty($inputData['Mobile'])) {
                $inputData['otp'] = rand(100000, 999999);
                $inputData['otp'] = 123456;
                if (!$checkPatientWithDoctor = $this->Patientmodel->checkPatientWithDoctor($inputData)) {
                    if ($addPatient = $this->Patientmodel->addPatient($inputData)) {
                        $result['Success'] = "TRUE";
                        $result['Message'] = 'Patient added successfully.';
                        $result['Result'] = array();
                        $result['PatientId'] = $addPatient;
                        $msg = 'Hi your verification OTP : ' . $inputData['otp'];
                        $smsText = str_replace(" ", "%20", $msg);
                        sendSMS($inputData['Mobile'], $smsText);
                        die(json_encode($result));
                    } else {

                        $result['Success'] = "FALSE";
                        $result['Message'] = 'Please check your Entry.';
                        $result['Result'] = array();
                        die(json_encode($result));
                    }
                } else {
                    if ($checkPatientWithDoctor->patient_status == 0) {
                        $arr = [
                            'otp' => $inputData['otp']
                        ];
                        $this->Patientmodel->UpdatePatient($arr, $checkPatientWithDoctor->patient_id);
                        $result['Success'] = "TRUE";
                        $result['Message'] = 'Patient added successfully.';
                        $result['PatientId'] = $checkPatientWithDoctor->patient_id;
                        $mobileNo = $inputData['Mobile'];
                        $msg = 'Hi your verification OTP :' . $inputData['otp'];
                        $smsText = str_replace(" ", "%20", $msg);
                        sendSMS($mobileNo, $smsText);
                        die(json_encode($result));
                    } else {
                        $result['Success'] = "FALSE";
                        $result['Message'] = 'Patient with this doctor already exist.';
                        $result['Result'] = array();
                        die(json_encode($result));
                    }
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function patientOTP()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['OTP'] = $this->input->post('OTP', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['PatientId'] && !empty($input_data)) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['OTP'] && !empty($input_data)) {
                $inputData['OTP'] = $input_data['OTP'];
            }
            //echo "<pre>";print_r($inputData); die;
            if ($inputData['PatientId'] && $inputData['OTP']) {
                if ($addPatient = $this->Patientmodel->patientOTP($inputData)) {
                    $this->Patientmodel->UpdateStatus($inputData['PatientId']);
                    $data['Details'] = $addPatient;
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'OTP matched successfully!';
                    $result['Result'] = $data;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Otp does not matched!';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Please check your Entry First.';
                $result['Result'] = array();
                die(json_encode($result));
            }
        }
    }

    public function GetPatientList()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $inputData['StartDate'] = $this->input->post('StartDate', TRUE);
            $inputData['EndDate'] = $this->input->post('EndDate', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }
            if (!$inputData['StartDate'] && isset($input_data['StartDate'])) {
                $inputData['StartDate'] = $input_data['StartDate'];
            }
            if (!$inputData['EndDate'] && isset($input_data['EndDate'])) {
                $inputData['EndDate'] = $input_data['EndDate'];
            }
            // print_r($inputData);die;
            if (!empty($inputData['UserId']) && !empty($inputData['StartDate']) && $inputData['EndDate']) {
                $res = $this->Patientmodel->getPatientList($inputData);
                if ($res) {
                    foreach ($res as $key => $val) {
                        $data[$key]['patient_id'] = $val['patient_id'];
                        $data[$key]['patient_name'] = $val['patient_name'];
                        $data[$key]['patient_mobile'] = $val['patient_mobile'];
                        if (trim($val['count_session'])) {
                            $data[$key]['last_session'] = $val['count_session'];
                        } else {
                            $data[$key]['last_session'] = 0;
                        }
                        $data[$key]['last_session_date'] = $val['last_schedule_date'];
                        $data[$key]['next_session_date'] = $val['next_schedule_date'];
                    }
                    $result['Success'] = "TRUE";
                    $result['Message'] = '';
                    $result['Result'] = $res;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "False";
                    $result['Message'] = 'Record not found!';
                    die(json_encode($result));
                }
            } elseif (!empty($inputData['UserId']) && empty($inputData['StartDate']) && empty($inputData['EndDate'])) {
                $res = $this->Patientmodel->getAllPatientList($inputData);
                if ($res) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = '';
                    $result['Result'] = $res;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "False";
                    $result['Message'] = 'Record not found!';
                    die(json_encode($result));
                }
            }
        }
    }

    public function pushCounselAssessment()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['CountStep'] = $this->input->post('CountStep', TRUE);
            $inputData['DateTime'] = $this->input->post('DateTime', TRUE);
            $inputData['Data1'] = $this->input->post('Data1', TRUE);
            $inputData['Data2'] = $this->input->post('Data2', TRUE);
            $inputData['Data3'] = $this->input->post('Data3', TRUE);
            $inputData['Data4'] = $this->input->post('Data4', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['CountStep'] && isset($input_data['CountStep'])) {
                $inputData['CountStep'] = $input_data['CountStep'];
            }
            if (!$inputData['DateTime'] && isset($input_data['DateTime'])) {
                $inputData['DateTime'] = $input_data['DateTime'];
            }
            if (!$inputData['Data1'] && isset($input_data['Data1'])) {
                $inputData['Data1'] = $input_data['Data1'];
            }
            if (!$inputData['Data2'] && isset($input_data['Data2'])) {
                $inputData['Data2'] = $input_data['Data2'];
            }
            if (!$inputData['Data3'] && isset($input_data['Data3'])) {
                $inputData['Data3'] = $input_data['Data3'];
            }
            if (!$inputData['Data4'] && isset($input_data['Data4'])) {
                $inputData['Data4'] = $input_data['Data4'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['DoctorId']) && !empty($inputData['PatientId'])) {
                if ($pushCounselAssessment = $this->Patientmodel->pushCounselAssessment($inputData)) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Patient Counsel Assessment added successfully';
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Please check your Entry.';
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function popCounselAssessment()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['CounStep'] = $this->input->post('CounStep', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['CounStep'] && isset($input_data['CounStep'])) {
                $inputData['CounStep'] = $input_data['CounStep'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['DoctorId']) && !empty($inputData['PatientId']) && !empty($inputData['CounStep'])) {
                if ($popCounselAssessment = $this->Patientmodel->popCounselAssessment($inputData)) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Patient Counsel Assessment fetched successfully';
                    $result['Result'] = [];
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Please check your Entry.';
                    $result['Result'] = [];
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function getPatientDetail()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            //print_r($inputData);die;
            if (!empty($inputData['PatientId'])) {
                $res = $this->Patientmodel->getPatientDetail($inputData);

                if ($res) {
                    if ($res->patient_status == 1) {
                        //echo '<pre>'; print_r($res); die;
                        $res->assessment_data = json_decode($res->assessment_data, true);
                        $res->assessment_data2 = json_decode($res->assessment_data2, true);
                        $res->assessment_data3 = json_decode($res->assessment_data3, true);
                        $res->assessment_data4 = json_decode($res->assessment_data4, true);
                        $res->data = json_decode($res->data, true);
                        if (!$res->assessment_data) {
                            $res->assessment_data = [];
                        }
                        if (!$res->assessment_data2) {
                            $res->assessment_data2 = [];
                        }
                        if (!$res->assessment_data3) {
                            $res->assessment_data3 = [];
                        }
                        if (!$res->assessment_data4) {
                            $res->assessment_data4 = [];
                        }
                        if (!$res->data) {
                            $res->data = [];
                        }
                        if (trim($res->count_session)) {
                            $res->last_session = $res->count_session;
                        } else {
                            $res->last_session = 0;
                        }
                        $res->last_session_date = $res->last_schedule_date;
                        $res->next_session_date = $res->next_schedule_date;
                        $res->alternative_number = $res->alternative_number;
                        $res->session1_data = json_decode($res->session1_data, true);
                        $res->session2_data = json_decode($res->session2_data, true);
                        $res->session3_data = json_decode($res->session3_data, true);
                        unset($res->next_schedule_date);
                        unset($res->last_schedule_date);
                        unset($res->last_session);
                        $result['Success'] = "TRUE";
                        $result['Message'] = '';
                        $result['Result'] = $res;
                        die(json_encode($result));
                    } else {
                        $result['Success'] = "False";
                        $result['Message'] = 'Otp is not verified, verified first!';
                        die(json_encode($result));
                    }
                } else {
                    $result['Success'] = "False";
                    $result['Message'] = 'Record not found!';
                    die(json_encode($result));
                }
            }
        }
    }

    public function updatePushCounselAssessment()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['CountStep'] = $this->input->post('CountStep', TRUE);
            $inputData['Data1'] = $this->input->post('Data1', TRUE);
            $inputData['Data2'] = $this->input->post('Data2', TRUE);
            $inputData['Data3'] = $this->input->post('Data3', TRUE);
            $inputData['Data4'] = $this->input->post('Data4', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['CountStep'] && isset($input_data['CountStep'])) {
                $inputData['CountStep'] = $input_data['CountStep'];
            }
            if (!$inputData['Data1'] && isset($input_data['Data1'])) {
                $inputData['Data1'] = ($input_data['Data1']);
            }
            if (!$inputData['Data2'] && isset($input_data['Data2'])) {
                $inputData['Data2'] = ($input_data['Data2']);
            }
            if (!$inputData['Data3'] && isset($input_data['Data3'])) {
                $inputData['Data3'] = ($input_data['Data3']);
            }
            if (!$inputData['Data4'] && isset($input_data['Data4'])) {
                $inputData['Data4'] = ($input_data['Data4']);
            }
            // echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['PatientId']) && !empty($inputData['DoctorId'])) {
                $arr = array(
                    'assessment_data' => json_encode($inputData['Data1']),
                    'assessment_data2' => json_encode($inputData['Data2']),
                    'assessment_data3' => json_encode($inputData['Data3']),
                    'assessment_data4' => json_encode($inputData['Data4']),
                    'coun_step' => $inputData['CountStep'],
                );
                if (!$inputData['Data1']) {
                    unset($arr['assessment_data']);
                }
                if (!$inputData['Data2']) {
                    unset($arr['assessment_data2']);
                }
                if (!$inputData['Data3']) {
                    unset($arr['assessment_data3']);
                }
                if (!$inputData['Data4']) {
                    unset($arr['assessment_data4']);
                }
                if (!$inputData['CountStep']) {
                    unset($arr['coun_step']);
                }
                if ($checkCounselAssessment = $this->Patientmodel->checkCounselAssessment($inputData['PatientId'], $inputData['DoctorId'])) {
                    if ($updatePushCounselAssessment = $this->Patientmodel->updatePushCounselAssessment($arr, $inputData['PatientId'], $inputData['DoctorId'])) {
                        $result['Success'] = "TRUE";
                        $result['Message'] = 'Patient Counsel Assessment updated successfully';
                        die(json_encode($result));
                    } else {
                        $result['Success'] = "TRUE";
                        $result['Message'] = "Nothing for update!";
                        die(json_encode($result));
                    }
                } else {
                    $result['Success'] = "False";
                    $result['Message'] = "Record not found in CounselAssessment table!";
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function UpdatePatientSession()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['LastSession'] = $this->input->post('LastSession', TRUE);
            $inputData['LastSessionDate'] = $this->input->post('LastSessionDate', TRUE);
            $inputData['NextSessionDate'] = $this->input->post('NextSessionDate', TRUE);
            $inputData['Session1_Data'] = $this->input->post('Session1_Data', TRUE);
            $inputData['Session2_Data'] = $this->input->post('Session2_Data', TRUE);
            $inputData['Session3_Data'] = $this->input->post('Session3_Data', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['LastSession'] && isset($input_data['LastSession'])) {
                $inputData['LastSession'] = $input_data['LastSession'];
            }
            if (!$inputData['LastSessionDate'] && isset($input_data['LastSessionDate'])) {
                $inputData['LastSessionDate'] = $input_data['LastSessionDate'];
            }
            if (!$inputData['NextSessionDate'] && isset($input_data['NextSessionDate'])) {
                $inputData['NextSessionDate'] = $input_data['NextSessionDate'];
            }
            if (!$inputData['Session1_Data'] && isset($input_data['Session1_Data'])) {
                $inputData['Session1_Data'] = $input_data['Session1_Data'];
            }
            if (!$inputData['Session2_Data'] && isset($input_data['Session2_Data'])) {
                $inputData['Session2_Data'] = $input_data['Session2_Data'];
            }
            if (!$inputData['Session3_Data'] && isset($input_data['Session3_Data'])) {
                $inputData['Session3_Data'] = $input_data['Session3_Data'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['DoctorId']) && !empty($inputData['PatientId'])) {
                $data = [
                    'count_session' => $inputData['LastSession'],
                    'last_schedule_date' => $inputData['LastSessionDate'],
                    'next_schedule_date' => $inputData['NextSessionDate'],
                    'session1_data' => json_encode($inputData['Session1_Data']),
                    'session2_data' => json_encode($inputData['Session2_Data']),
                    'session3_data' => json_encode($inputData['Session3_Data']),
                ];
                if (empty(($inputData['Session1_Data']))) {
                    unset($data['session1_data']);
                }
                if (empty(($inputData['Session2_Data']))) {
                    unset($data['session2_data']);
                }
                if (empty(($inputData['Session3_Data']))) {
                    unset($data['session3_data']);
                }
               
                if ($pushCounselAssessment = $this->Patientmodel->UpdatePatientSession($data, $inputData)) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Patient details updated successfully';
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Please check your Entry.';
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function UpdateNextSessionDate()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['NextSessionDate'] = $this->input->post('NextSessionDate', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['NextSessionDate'] && isset($input_data['NextSessionDate'])) {
                $inputData['NextSessionDate'] = $input_data['NextSessionDate'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['DoctorId']) && !empty($inputData['PatientId'])) {
                $data = [
                    'next_schedule_date' => $inputData['NextSessionDate'],
                ];

                if ($pushCounselAssessment = $this->Patientmodel->UpdatePatientSession($data, $inputData)) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Patient next session date updated successfully';
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Please check your Entry.';
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function UpdatePatientDetails()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['DoctorId'] = $this->input->post('DoctorId', TRUE);
            $inputData['PatientId'] = $this->input->post('PatientId', TRUE);
            $inputData['Name'] = $this->input->post('Name', TRUE);
            $inputData['Gender'] = $this->input->post('Gender', TRUE);
            $inputData['AlternateMobile'] = $this->input->post('AlternateMobile', TRUE);
            $inputData['Data'] = $this->input->post('Data', TRUE);
            $inputData['Age'] = $this->input->post('Age', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['DoctorId'] && isset($input_data['DoctorId'])) {
                $inputData['DoctorId'] = $input_data['DoctorId'];
            }
            if (!$inputData['PatientId'] && isset($input_data['PatientId'])) {
                $inputData['PatientId'] = $input_data['PatientId'];
            }
            if (!$inputData['Name'] && isset($input_data['Name'])) {
                $inputData['Name'] = $input_data['Name'];
            }
            if (!$inputData['Gender'] && isset($input_data['Gender'])) {
                $inputData['Gender'] = $input_data['Gender'];
            }
            if (!$inputData['AlternateMobile'] && isset($input_data['AlternateMobile'])) {
                $inputData['AlternateMobile'] = $input_data['AlternateMobile'];
            }
            if (!$inputData['Data'] && isset($input_data['Data'])) {
                $inputData['Data'] = $input_data['Data'];
            }
            if (!$inputData['Age'] && isset($input_data['Age'])) {
                $inputData['Age'] = $input_data['Age'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['DoctorId']) && !empty($inputData['PatientId'])) {
                $data = [
                    'patient_name' => $inputData['Name'],
                    'gender' => $inputData['Gender'],
                    'patient_age' => $inputData['Age'],
                    'alternative_number' => $inputData['AlternateMobile'],
                    'data' => json_encode($inputData['Data']),
                ];

                if ($pushCounselAssessment = $this->Patientmodel->UpdatePatientSession($data, $inputData)) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Patient details updated successfully';
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Please check your Entry.';
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function TodayAppointmentList()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }

            // print_r($inputData);die;
            if (!empty($inputData['UserId'])) {
                $res = $this->Patientmodel->getTodayAppointmentList($inputData);
                if ($res) {
                    foreach ($res as $key => $val) {
                        $data[$key]['patient_id'] = $val['patient_id'];
                        $data[$key]['patient_name'] = $val['patient_name'];
                        $data[$key]['patient_mobile'] = $val['patient_mobile'];
                        if (trim($val['count_session'])) {
                            $data[$key]['last_session'] = $val['count_session'];
                        } else {
                            $data[$key]['last_session'] = 0;
                        }
                        $data[$key]['last_session_date'] = $val['last_schedule_date'];
                        $data[$key]['next_session_date'] = $val['next_schedule_date'];
                    }
                    $result['Success'] = "TRUE";
                    $result['Message'] = '';
                    $result['Result'] = $res;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Record not found!';
                    die(json_encode($result));
                }
            } else {

                $result['Success'] = "False";
                $result['Message'] = 'Invalid given request!';
                die(json_encode($result));
            }
        } else {

            $result['Success'] = "False";
            $result['Message'] = 'Invalid request!';
            die(json_encode($result));
        }
    }
}
