<?php
class Productsmodel extends CI_Model
{

    public function __construct()
    { 

        parent::__construct();
    }

	public function isMobileOrEmailExist($mobileNo=NULL,$email=NULL){
		if($email !== NULL && $mobileNo !==NULL){
			if($this->checkExistingMobile($mobileNo)){
				$msg = 'Mobile number already exist.';
				return $msg;
			}
			if($this->checkExistingEmail($email)){
				$msg = 'Email already exist.';
					return $msg;
			}else{
				return false;
			}
		}else{
			return true;
		}
	}

	public function checkExistingMobile($mobileNo = NULL) {
		$this->db->select('c.mobile_no,c.email_id');
        $this->db->from('customer c');
		$this->db->where('mobile_no', $mobileNo);
        $query = $this->db->get();
		if($query->num_rows()){
			return true;
		}
		else{
			return false;
		}
    }
	public function checkExistingEmail($email = NULL) {
		$this->db->select('c.email_id');
        $this->db->from('customer c');
		$this->db->where('email_id', $email);
		$query = $this->db->get();
		if($query->num_rows()){
			return true;
		}
		else{
			return false;
		}
    }

	public function userRegistration($data){
		$userTable = array(
					'full_name'=>$data['FullName'],
					'mobile_no'=>$data['MobileNo'],
					'email_id'=>$data['Email'],
					'password'=>md5($data['Password']),
					'address'=>$data['Address'],
			);
		$query = $this->db->insert('customer',$userTable);
		$inserted_Id = $this->db->insert_id();
		return $inserted_Id;
	}

	public function userLogin($data) {
		$this->db->select('id_customer,email_id,mobile_no,full_name,city_id,state_id,address,profile_img,hc_created_date');
        $this->db->from('customer c');
		$this->db->where('mobile_no', $data['MobileNo']);		
		$this->db->where('password', md5($data['Password']));		
		$this->db->limit(1);
        $query = $this->db->get();        
	//	echo $this->db->last_query();die;
		return $query->result_array();		
    }
	public function checkUserMobile($mobileNo){
		$this->db->select('c.mobile_no,c.email_id');
        $this->db->from('customer c');
		$this->db->where('mobile_no', $mobileNo);
        $query = $this->db->get();
		$res = $query->result_array();
		if($query->num_rows()){
			return $res;
		}
		else{
			return false;
		}
    }
	public function getRecipes($status=NULL,$filter=null){
		$this->db->select('*');
        $this->db->from('recipes');
        $this->db->order_by('recipe_id','desc');
		if($status){
			$this->db->where('recipe_status', $status);
		}
		if($filter){
			$this->db->where('recipe_meal_type', $filter);
		}
        $query = $this->db->get();
		//echo $this->db->last_query(); die;
		$res = $query->result_array();
		if($query->num_rows()){
			return $res;
		}
		else{
			return false;
		}
    }
	public function getRecipesCusine($status=NULL,$filter=null){
		$this->db->select('*');
        $this->db->from('recipes');
        $this->db->order_by('recipe_id','desc');
		if($status){
			$this->db->where('recipe_status', $status);
		}
		if($filter){
			$this->db->where('recipe_cusine', $filter);
		}
        $query = $this->db->get();
		//echo $this->db->last_query(); die;
		$res = $query->result_array();
		if($query->num_rows()){
			return $res;
		}
		else{
			return false;
		}
    }

	public function updateUserPass($data){
		$this->db->where('mobile_no', $data['MobileNo']);
		$updateData['password'] = md5($data['Password']);
		$query = $this->db->update('customer',$updateData);
		if($this->db->affected_rows())
			return true;
		else
			return false;
	}
	
	public function categoryList($CatId=NULL){
		$this->db->select('*');
        $this->db->from('categories c');
		$this->db->order_by('c.cat_name','desc');
		$this->db->where('cat_status', '1');
		if($CatId){
			$this->db->where('parent_id', $CatId);
		}else{			
			$this->db->where('parent_id','0');
		}
        $query = $this->db->get();
		$res = $query->result_array();
		return $res;
	}
	public function getcategoryById($CatId=null,$subcatname=null,$parent_id=null){
		$this->db->select('*');
        $this->db->from('categories c');
		$this->db->order_by('c.cat_name','asc');
		$this->db->where('cat_status', '1');
		if($CatId){
			$this->db->where('id', $CatId);
		} 
		if($subcatname){
			$this->db->where('cat_url', $subcatname);
		} 
		if($parent_id){
			$this->db->where('parent_id', $parent_id);
		} 
        $query = $this->db->get(); 
		if ($query->num_rows() > 0) 
		{
			$res = $query->result_array()[0];
			return $res; 
		}else			
			return false;
		
	}
	public function categoryAllList(){
		$this->db->select('c.cat_name as catname,c.cat_status as catstatus,c.category_banner as catbanner,c.id as catid, c.parent_id as catparentid');
        $this->db->from('categories c');
    //    $this->db->join('categories sc','sc.parent_id = c.id');
		$this->db->order_by('c.cat_name','desc');
		$this->db->where('c.cat_status', '1');
		$this->db->where('c.parent_id','0');		
        $query = $this->db->get();
	//	echo $this->db->last_query(); die;
		$res = $query->result_array();
		return $res;
	}
	public function productlist($data){
		$this->db->select('*,products.product_id as pid');
		$this->db->from('products');
        $this->db->join('categories sc','sc.id = products.product_sub_cat_id','left');
		$this->db->where('products.status','1');		
		$this->db->order_by('products.product_name','asc');
		
		if($data['patCategoryID'])
			$this->db->where('product_cat_id',$data['patCategoryID']);
		else
			$this->db->where('product_sub_cat_id',$data['CategoryID']);	
		if($data['is_new']){
			$this->db->where('is_new','1');
		}
		
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0) 
		{				
			$row = $query->result_array();

			return $row;			
		}else			
			return false;
	}
	public function allproductlist($data){
		$this->db->select('*,products.product_id as pid');
		$this->db->from('products');
		$this->db->where('products.status','1');		
	//	$this->db->where('products.product_url',$data['all']);		
		$this->db->limit('10');		
		$this->db->order_by('products.product_id','desc');		
		$query = $this->db->get();
	//	echo $this->db->last_query(); die;
		if ($query->num_rows() > 0) 
		{				
			$row = $query->result_array();

			return $row;			
		}else			
			return false;
	}
	public function allproductlist2($data){
		$this->db->select('*,products.product_id as pid');
		$this->db->from('products');
		$this->db->where('products.status','1');		
		$this->db->where('products.product_url',$data['all']);		
		$this->db->limit('10');		
		$this->db->order_by('products.product_id','desc');		
		$query = $this->db->get();
	//	echo $this->db->last_query(); die;
		if ($query->num_rows() > 0) 
		{				
			$row = $query->result_array();

			return $row;			
		}else			
			return false;
	}
	public function allTopProductlist(){
		$this->db->select('*,products.product_id as pid');
		$this->db->from('products');
		$this->db->where('products.status','1');		
		$this->db->where('products.product_type','top');		
		$this->db->limit('10');		
		$this->db->order_by('products.product_id','desc');		
		$query = $this->db->get();
	//	echo $this->db->last_query(); die;
		if ($query->num_rows() > 0) 
		{				
			$row = $query->result_array();

			return $row;			
		}else			
			return false;
	}
	function getProductListWhereIn($proIds){
		if($proIds){
			$this->db->select('*,products.product_id as pid');
			$this->db->from('products');	
			$this->db->where('products.status','1');	
			$this->db->where_in('products.product_id',$proIds);	
			$query = $this->db->get();
		//	echo $this->db->last_query(); die;
			if ($query->num_rows() > 0){
				$row = $query->result_array();
				return $row;			
			}else			
				return 0;
		}else{
			return 0;
		}
	}
	function productAttachments($pid){
		$this->db->select('product_attachment');
		$this->db->from('product_attachment');	
		$this->db->where('product_id',$pid);	
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0) 
		{
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	function citylist(){
		$this->db->select('*');
		$this->db->from('city');	
		$this->db->where('parent_id !=0');	
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	function recipesList($proId){
		$this->db->select('*');
		$this->db->from('recipes');	
		$this->db->order_by('rand()');
		$this->db->where('recipe_status','1');	
		$this->db->where_in('recipe_product_id',$proId);	
		$query = $this->db->get();
	//	echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){
			$row = $query->result_array();
			return $row;			
		}else			
			return 0;
	}
	function recipiedetails($recipe_url){
		$this->db->select('*');
		$this->db->from('recipes');	
		$this->db->where('recipe_url',$recipe_url);	
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){
			$row = $query->result_array();
			return $row;			
		}else			
			return 0;
	}
	function productdetails($data){
		$this->db->select('*,categories.cat_name catname ,products.product_id as pid,sub.cat_name subcategoryName');
	//	$this->db->select('*,categories.cat_name catname ,products.product_id as pid');
		$this->db->from('products');	
		$this->db->join('categories','categories.id = products.product_cat_id');
		$this->db->join('categories sub','sub.id = products.product_sub_cat_id','left');
	//	$this->db->join('recipes r','r.recipe_product_id = products.product_id','left');
		$this->db->where('product_url',$data['ProductUrl']);		
		$this->db->order_by('products.product_id','desc');				
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	function productdetailsbyid($productId){
		$this->db->select('*,categories.cat_name catname ,products.product_id as pid,sub.cat_name subcategoryName');
		$this->db->from('products');	
		$this->db->join('categories','categories.id = products.product_cat_id');
		$this->db->join('categories sub','sub.id = products.product_sub_cat_id','left');
		$this->db->where('product_id',$productId);		
		$this->db->order_by('products.product_id','desc');				
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	function productdetailsbyids($productId){
		if($productId){
			$this->db->select('*,categories.cat_name catname ,products.product_id as pid,sub.cat_name subcategoryName');
			$this->db->from('products');	
			$this->db->join('categories','categories.id = products.product_cat_id');
			$this->db->join('categories sub','sub.id = products.product_sub_cat_id','left');
			$this->db->where_in('product_id',$productId);		
			$this->db->order_by('products.product_id','desc');				
			$query = $this->db->get();
		//	echo $this->db->last_query(); die;
			if ($query->num_rows() > 0){
				$row = $query->result_array();
				return $row;			
			}else			
				return false;
		}else			
			return false;
	}
	public function feedback($data){
		$arr = array(
			'customer_order_id'=>$data['CustomerOrderId'],
		//	'allocated_delievery_id'=>$data['AllocatedDelieveryId'],
			'customer_name'=>$data['CustomerName'],
			'email_id'=>$data['EmailId'],
			'moblie_no'=>$data['MoblieNo'],
			'city_id'=>$data['CityId'],
			'message'=>$data['Message'],
			'rating_id'=>$data['Rating'],
		);
		$this->db->insert('feedback',$arr);
		return $this->db->insert_id();
	}
	public function addtofav($custID){
		$this->db->select('*');
		$this->db->from('customer_fav');	
		$this->db->where('fav_customer_id',$custID);	
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){ 
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	public function searchproducts($term){
		$this->db->select('*');
		$this->db->from('products');
		$this->db->where('status','1');		
		$this->db->like('product_name',$term);	
		$this->db->or_like('product_name_hindi',$term);	
		$query = $this->db->get();
		//echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){ 
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
	public function searchproductsapp($term=null){
		$this->db->select('*');
		$this->db->from('products');
		$this->db->join('categories c' ,'c.id = products.product_cat_id');
		$this->db->where('status','1');
		if($term){
			$this->db->like('product_name',$term);	
			$this->db->or_like('product_name_hindi',$term);	
		}
		$query = $this->db->get();
	//	echo $this->db->last_query(); die;
		if ($query->num_rows() > 0){ 
			$row = $query->result_array();
			return $row;			
		}else			
			return false;
	}
}
?>