<?php
class Dashboard extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('Dashboardmodel');
		$this->load->model('Doctormodel');
		$this->load->model('Patientmodel');
		$this->load->library('upload');
		//if(!isLoggedIn() && !isSuperAdmin())
         //redirect('login');
	}
	public function index(){	
		if(isset($_POST['filter'])){ 
				if($this->input->post('custumer_status'))
					$custumer_status = $this->input->post('custumer_status');
				else
					$custumer_status =NULL;
				
				if($this->input->post('fromdate') != '' && $this->input->post('todate') != ''){
					$todate = $this->input->post('todate');
					$fromdate = $this->input->post('fromdate');
				}else{
					$fromdate =NULL;
					$todate =NULL;
				}
				$data['orderList'] = $this->Dashboardmodel->orderList($fromdate,$todate,$custumer_status);
		}else{
			$todayDay = date('d') - 1 ;
			$todate = date('d-m-Y');			
			$fromdate = date('d-m-Y', strtotime('-'.$todayDay.' day', strtotime($todate)));
			$_POST['fromdate'] = $fromdate;
			$_POST['todate'] = $todate;
			$data['orderList'] = $this->Dashboardmodel->orderList($fromdate,$todate);
		}
		if($data['orderList']){
			$total = 0; $i=0;
			foreach($data['orderList'] as $key => $olist){ 
				$result['orderList'][$olist['order_status']][date('d-M-y',strtotime($olist['order_date_time']))][] =   ($olist['purchase_price'] -  $olist['discount_price']);
				$result['returnCustomers'][$i] = $olist['customer_id'];
				$i++;
			}			
		}else{
			$result['orderList'] = '';
		}
		$result['CustomerList'] = $this->Dashboardmodel->CustomerList($fromdate,$todate); 
		$data['emailSubscribers'] = $this->Dashboardmodel->emailSubscribers();
		if($data['emailSubscribers']){
			$total = 0;
			foreach($data['emailSubscribers'] as $key => $elist){
				$result['emailSubscribers'][date('d-M-y',strtotime($elist['email_subscription_created_date']))][] =  $elist;
			}
		}else{
			$result['emailSubscribers'] = '';
		}
		$data['customerFeedbacks'] = $this->Dashboardmodel->customerFeedbacks();
		if($data['customerFeedbacks']){
			$total = 0;
			foreach($data['customerFeedbacks'] as $key => $flist){ 
				$result['customerFeedbacks'][date('d-M-y',strtotime($flist['created_date']))][] =   $flist['feedback_id']; 
				$result['customerFeedbacksRating'][date('d-M-y',strtotime($flist['created_date']))][] = $flist['rating_id'];
			}			
		}else{
			$result['customerFeedbacks'] = '';
		}
		$result['doctorcount'] = $this->Doctormodel->getDoctorRecords();
		$result['patientcount'] = $this->Patientmodel->getPatientRecords();
		//$result['citycount'] = $this->Citymodel->getCity();
		$this->load->view('include/header',$result);
		$this->load->view('include/breadcrum');
		$this->load->view('view_dashboard');
		$this->load->view('include/footer');
	}
	public function addBlog(){
		$data['categoryLists'] = $this->Categoriesmodel->getCategories($status='1');
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum');
		$this->load->view('add_blog', $data);
		$this->load->view('include/footer');
	}
	public function editBlog(){
		$data['categoryLists'] = $this->Categoriesmodel->getCategories($status='1');
		$data['blogs'] = $this->Blogmodel->getBlogList('',$this->input->get('Id'));
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('edit_blog');
		$this->load->view('include/footer');
	}
	public function submitBlog(){
		$data=$this->input->post();
	if(!$d=$this->Blogmodel->getBlogList('','','',$blog_title = $data['blog_title'])){
		$attachment ="";
		if($data){
		    if($_FILES['blog_img']['name'] !="")
		    {
				$fieldName = 'blog_img';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'blog_img'.time().'.'.$ext;
				$this->upload->initialize($this->set_upload_options($attachment));
				
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success"; //die;
			}
			else
			{
				$error = array('error' => $this->upload->display_errors());
			}
				$data['blog_img'] = $attachment;
				$result=$this->Blogmodel->submitBlogWithImg($data);				
				$this->session->set_flashdata('alert', 'Blog Submit Successfully!');	
				redirect(base_url().'AdminBlog/');
			}else{	
				$result=$this->Blogmodel->submitBlog($data);
				$this->session->set_flashdata('alert', 'Blog Submit Successfully!');	
				redirect(base_url().'AdminBlog/');
			}
		}
	}else{	
			$this->session->set_flashdata('alert', 'This Name is already exist <b>'.'</b> ');	
			redirect(base_url().'AdminBlog/');		
		}
	
	
}
	public function updateBlog(){
		$data=$this->input->post();
		if($data){			
		    if($_FILES['blog_img']['name'] !="")
		    {
				$fieldName = 'blog_img';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'blog_img'.time().'.'.$ext;
				$this->upload->initialize($this->set_upload_options($attachment));
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success";
			}
			else
			{
				$error = array('error' => $this->upload->display_errors());
			}
				$data['blog_img'] = $attachment;
				$result=$this->Blogmodel->updateBlogWithImg($data);
			}else{	
			
				$result=$this->Blogmodel->updateBlog($data);
			}
		}
		redirect(base_url().'AdminBlog/');
	}
	public function categoryActiveStatus(){
	    $result = $this->Blogmodel->ActiveStatus();
		redirect(base_url().'AdminBlog/');
	}
	private function set_upload_options($imageName)
	{   
		$config = array();
		$config['upload_path'] = 'upload/';
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		$config['max_size']      = '50000KB';
		$config['overwrite']     = FALSE;
		$config['file_name']	 = $imageName;
		return $config;
	}
}
?>