<?php

class Doctor extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Doctormodel');
        $this->load->model('Citymodel');
        $this->load->model('Clinicmodel');
        $this->load->model('Patientmodel');
    }

    public function index() {
        $data['doctor'] = $this->Doctormodel->getDoctorRecords();
		//$data['clinic'] = $this->Clinicmodel->getClinicRecords();
		//$data['patient'] = $this->Patientmodel->getPatientRecords();
		//echo "<pre>";print_r($data['doctor']);die;
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_doctor_list', $data);
        $this->load->view('include/footer');
    }

    public function addDoctor() {
        $data['city'] = $this->Citymodel->getCity();
        $data['state'] = $this->Citymodel->getState();
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('add_doctor', $data);
        $this->load->view('include/footer');
    }

    public function submitDoctor() {
        $result = $this->input->post();
        //echo "<pre>";print_r($result['doctor_mobile']);die;
     	if(! $this->Doctormodel->getDoctorRecords('',$mobile= $result['doctor_mobile'])){
           $data=  $this->Doctormodel->addDoctor($result);
            if ($data) {
                $this->session->set_flashdata('alert', "Doctor Details Inserted Successfully");
                redirect('doctor');
            }
        }else{
        		$this->session->set_flashdata('alert', "Mobile Number already exists");
                redirect('doctor');
        }
    }

    public function manageDoctorDetails() {

        $data['doctor'] = $this->Doctormodel->getDoctorRecords();
        //echo "<pre>";print_r($data['doctor']);die;
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_doctor_list', $data);
        $this->load->view('include/footer');
    }

    public function editDoctorDetails() {
        $data['doctor'] = $this->Doctormodel->getDoctorRecords($this->input->get('Id'));
        //echo "<pre>";print_r($data['doctor']);die;
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('edit_doctor', $data);
        $this->load->view('include/footer');
    }
	
	public function viewPatientDetails(){
		//echo $this->input->get('Id');die;
		$data['patient'] = $this->Doctormodel->getPatientRecords($this->input->get('Id'));
		//echo "<pre>";print_r($data['patient']);die;
		$this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_patient_details', $data);
        $this->load->view('include/footer');
	}
	
	public function viewClinicDetails(){
		$data['clinic'] = $this->Doctormodel->getClinicRecords($this->input->get('Id'));
		//echo "<pre>";print_r($data['doctor']);die;
		$this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_clinic_details', $data);
        $this->load->view('include/footer');
	}
	
    public function updateDoctor() {
        $data = $this->input->post();
        $result = $this->Doctormodel->updateDoctor($data);
        if ($result) {
            $this->session->set_flashdata('alert', "Doctor Details Update Successfully");
            redirect('doctor');
        }
    }

    public function deleteDoctorInfo($id) {

        $result = $this->Doctormodel->deleteDoctor($id);
        if ($result) {
            redirect("doctor/manageDoctorDetails?msg=delete");
        }
    }

    public function ActiveStatus() {
        $result = $this->Doctormodel->ActiveStatus($this->input->post());
        if ($result) {
            redirect('doctor');
        }
    }
    public function getCityByStateId(){
        $stateId = $this->input->get('stateId');
        if($stateId){
            $data = $this->Doctormodel->getCityByStateId($stateId);
            if($data){
            //echo '<pre>'; print_r($data); die;
                $x = '<select>';
                foreach($data as $key => $val){
                    $x .='<option value="'.$val['city_id'].'">'.$val['city_name'].'</option>';
                }
                $x .='</select>';
                echo  $x;     die; 
            }
            echo  false;
        }
    }

}

?>