<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Citymodel extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function getState($state_status = NULL) {
        $this->db->order_by("state_name", "asc");
        $query = $this->db->get('states');
        return $query->result_array();
    }

    public function getCity($city_Id = NULL) {
		//echo getCity();die;
        $this->db->select('*');
        $this->db->from('city');
        
        //$this->db->order_by('doctor_id', 'desc');
		if($city_Id){
			 $this->db->where('city_id', $city_Id);
		}
        $query = $this->db->get();
        //echo  $this->db->last_query();die;
        return $query->result_array();
    }

    public function get_cities_bk($cityId = Null) {
        $this->db->select('*, c.city_id as cityId, c.city_name as cityName,s.state_name as stateName');
        $this->db->from('city c');
        $this->db->join('states s', 's.state_id = c.state_id');

        //$this->db->where('c.city_id != ', '0');
        //$this->db->order_by('cd.city_id', 'asc');
        if ($cityId)
            $this->db->where('c.city_id', $cityId);
        $query = $this->db->get();
        return $query->result();
    }

    public function addCity($data) {
		//print_r($data);die;
        $query = array(
			'state_id' => $data['state'],
            'city_name' => ucfirst($data['city']),
        );
		//print_r($query);die;
        $qry = $this->db->insert('city', $query);
        return true;
    }
	public function updateCity($data)
	{
		//print_r($data);die;
		$id = $this->input->get('city_id');
		//print_r ($data);die;
		$query = array(
			'state_id' => $data['state'],
			'state_name' => $data['state_name'],
			'city_name' => ucfirst($data['city']),
		  );
		$this->db->where('city_id',$this->input->get('Id'));
		$this->db->update('city', $query,$id);
		return true;
	}
    public function getCityName($id) {
        if (!empty($id)) {
            $query = $this->db->select('city_name')
                    ->from('city')
                    ->where('id_city', $id)
                    ->get();
            if ($query->num_rows() > 0) {
                $result = $query->row();
                return $result->city_name;
            }
        }
    }

    public function getCustomerFeedback() {
        $this->db->where('fd_state', '1');
        $this->db->order_by('feedback_id', 'desc');
        $query = $this->db->get('feedback');
        return $query->result_array();
    }

    public function getManageFeedback() {
        $this->db->select('*');
        $this->db->from('feedback');
        $this->db->join('city', 'city.city_id = feedback.city_id');
        $this->db->order_by('feedback_id', 'desc');
        $query = $this->db->get();
        // echo "<pre>";print_r($query->result_array());die;
        return $query->result_array();
    }

    public function addFeedbackClient($data) {
        //echo "<pre>";print_r($query);die;
        $query = array(
            'customer_order_id' => $data['orderId'],
            'allocated_beautician_id' => $data['beauticianId'],
            'customer_name' => $data['name'],
            'email_id' => $data['email'],
            'moblie_no' => $data['phone'],
            'city_id' => $data['city'],
            'rating_id' => $data['rating'],
            'message' => $data['message'],
            'fd_state' => '0',
            'created_date' => date('Y-m-d')
        );
        //echo "<pre>";print_r($query);die;
        $this->db->insert('feedback', $query);
        //echo "<pre>";print_r($this->db->last_query());die;
        return $query;
    }

    function cancelFeedbackStatus($data) {
        $id = $this->input->get('inactiveStatusId');
        $value = $this->input->get('statusValue');
        $arr = array(
            'fd_state' => $value
        );
        $this->db->where('feedback_id', $id);
        $this->db->update('feedback', $arr);

        return true;
    }

    public function getCustomerFeedbackByCityName($cityId) {
        $this->db->where('fd_state', '1');
        $this->db->where('city_id', $cityId);
        $this->db->order_by('feedback_id', 'desc');
        $query = $this->db->get('feedback');
        return $query->result_array();
    }

    public function addMoreCity($data) {
        $arr = array(
            'city_name' => $data['cityname']
        );
        $result1 = $this->db->insert('more_city', $arr);
        return true;
    }

    function ActiveStatus() {
        $id = $this->input->get('ActiveStatus');
        $value = $this->input->get('statusValue');
        $arr = array(
            'city_status' => $value
        );
        $this->db->where('id_city', $id);
        $this->db->update('city', $arr);
        return true;
    }

    public function get_cities_bk_price($cityId = Null) {
        $this->db->select('*, c.city_id as cityId, c.city_name as cityName,s.state_name as stateName,s.city_id as stateId');
        $this->db->from('city c');
        $this->db->join('city_detail cd', 'cd.city_id = c.city_id');
        $this->db->join('city s', 's.city_id = c.parent_id');
        $this->db->where('c.parent_id != ', '0');
        //$this->db->order_by('cd.city_id', 'asc');
        if ($cityId)
            $this->db->where('c.city_id', $cityId);
        $query = $this->db->get();
        return $query->result();
    }



}

?>