<?php
class AdminBlog extends CI_Controller

{
	function __construct()
	{
		parent::__construct();
		$this->load->model('blog/Blogmodel');
		//$this->load->model('product/Projectsmodel');
		$this->load->model('blogcategories/Categoriesmodel');
		$this->load->library('upload');
		if(!isLoggedIn() && !isSuperAdmin())
         redirect('login');
	}
	
	public function index(){	
		$data['blogs'] = $this->Blogmodel->getBlogList();
		
		//echo "<pre>"; print_r($data); die;
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('view_blog_list');
		$this->load->view('include/footer');
	}
	
	public function addBlog(){
		$data['categoryLists'] = $this->Categoriesmodel->getCategories($status='1');
		//$this->Blogmodel->getBlogCategories(); 
		//print_r($data['categoryLists']); die;
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum');
		$this->load->view('add_blog', $data);
		$this->load->view('include/footer');
	}

	public function editBlog(){
		$data['categoryLists'] = $this->Categoriesmodel->getCategories($status='1');
		//$this->Projectsmodel->getCategories();
		
		$data['blogs'] = $this->Blogmodel->getBlogList('',$this->input->get('Id'));
		//echo "<pre>"; print_r($data); die;
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('edit_blog');
		$this->load->view('include/footer');
	}
	
	public function submitBlog(){
	
		$data=$this->input->post();
	if(!$d=$this->Blogmodel->getBlogList('','','',$blog_title = $data['blog_title'])){
		$attachment ="";
		if($data){
				
		    if($_FILES['blog_img']['name'] !="")
		    {
				$fieldName = 'blog_img';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'blog_img'.time().'.'.$ext;
				$this->upload->initialize($this->set_upload_options($attachment));
				
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success"; //die;
			}
			else
			{
				$error = array('error' => $this->upload->display_errors());
				
			}
				$data['blog_img'] = $attachment;
			//	echo "<pre>"; print_r($data); die;
		
				$result=$this->Blogmodel->submitBlogWithImg($data);				
				$this->session->set_flashdata('alert', 'Blog Submit Successfully!');	
				redirect(base_url().'AdminBlog/');
			}else{	
			
				$result=$this->Blogmodel->submitBlog($data);
				$this->session->set_flashdata('alert', 'Blog Submit Successfully!');	
				redirect(base_url().'AdminBlog/');
			}
		}
	}else{	
			$this->session->set_flashdata('alert', 'This Name is already exist <b>'.'</b> ');	
			redirect(base_url().'AdminBlog/');		
		}
	
	
}
		
	
	
	public function updateBlog(){
		$data=$this->input->post();
		
		if($data){		
					
		    if($_FILES['blog_img']['name'] !="")
		    {
				$fieldName = 'blog_img';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'blog_img'.time().'.'.$ext;
				$this->upload->initialize($this->set_upload_options($attachment));
				
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success"; //die;
			}
			else
			{
				$error = array('error' => $this->upload->display_errors());
				
			}
				$data['blog_img'] = $attachment;
			//	echo "<pre>"; print_r($data); die;
		
				$result=$this->Blogmodel->updateBlogWithImg($data);
			    //print_r($_FILES); die;
			}else{	
			
				$result=$this->Blogmodel->updateBlog($data);
			}
			//$result=$this->Blogmodel->updateFaq($data);
		}
		redirect(base_url().'AdminBlog/');
	}
	public function categoryActiveStatus(){
		//echo "s,dmv,s"; die;
	    $result = $this->Blogmodel->ActiveStatus();
		redirect(base_url().'AdminBlog/');
	}
	private function set_upload_options($imageName)
	{   
		//upload an image options
		$config = array();
		$config['upload_path'] = 'upload/';
		$config['allowed_types'] = 'gif|jpg|png|jpeg';
		$config['max_size']      = '50000KB';
		$config['overwrite']     = FALSE;
		$config['file_name']	 = $imageName;

		return $config;
	}
}
?>