<?php
class City extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('citymodel');			
		if(!isLoggedIn() || !isSuperAdmin())
         redirect('Login');	
	}
	public function index()
	{
			$data['cityName'] = $this->citymodel->get_cities_bk();
			$data['stateName'] = $this->citymodel->getState();
			//echo "<pre>";print_r($data);die;
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('view_city',$data);
			$this->load->view('include/footer');
	}
	public function addCityContent()
	{
		$data['cityName'] = $this->citymodel->get_cities_bk();
		$data['stateName'] = $this->citymodel->getState();
		//$data['cityList'] = $this->citymodel->getCity();
		//echo "<pre>";print_r($data);die;
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_city',$data);
		$this->load->view('include/footer');
	}
    public function submitCity() {
        $result = $this->input->post();
        //echo "<pre>";print_r($result);die;
           $data=  $this->citymodel->addCity($result);
           redirect(base_url() . 'city');
    }
	public function editCityContent()
	{
		$data['cityName'] = $this->citymodel->get_cities_bk();
		$data['stateName'] = $this->citymodel->getState();
		//$data['city'] = $this->Citymodel->getCity();
		$data['cityList'] = $this->citymodel->getCity($this->input->get('Id'));
		//echo "<pre>";print_r($data['stateName']);die;
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('edit_city',$data);
		$this->load->view('include/footer');
	}
	public function updateCity() 
	{
		$data= $this->input->post();
		//print_r($data);die;
		$result = $this->citymodel->updateCity($data);
		if($result) 
		{
			$this->session->set_flashdata('alert', 'Patient Details Update Successfully!');	
			redirect(base_url().'city');
		}
	}
	public function updateCityPageContent()
	{
		$data = $this->input->post();
		$Id = $this->input->get('cityDetailsId');
		if($result){
			redirect('city/');
		}
		
	}
	public function getCityContent()
	{
		$cityId = $this->input->get('id');
		$data['cityId'] = $cityId;
		$data['cityList'] = $this->citymodel->getCity();
		$data['cityLocality'] = $this->Seomodel->getCityLocality($cityId);
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('seoPageList',$data);
			$this->load->view('include/footer');
	}
	
	public function getFeedBack()
	{       
        
	    $data['feedback'] = $this->citymodel->getManageFeedback();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('view_feedback_list',$data);
		$this->load->view('include/footer');		
	 
	    
	}
	public function feedbackActiveStatus()
	{       
	    $result = $this->citymodel->cancelFeedbackStatus($this->input->post());
		if($result)			
		{				
	    $data['feedback'] = $this->citymodel->getManageFeedback();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('view_feedback_list',$data);
		$this->load->view('include/footer');		
	 
	    }
	}	
	public function getCityLocality()
	{
		$cityId = $this->input->get('id');
		$data['cityId'] = $cityId;
		$data['cityList'] = $this->citymodel->get_cities_bk();
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('seocitylocality',$data);
			$this->load->view('include/footer');
	}
	public function addCityLocality()
	{
		$Cityid = $this->input->get('id');
		$data['CityId']= $Cityid;
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_city_locality', $data);
		$this->load->view('include/footer');
	}
	public function insertCityLocality()
	{
		$data = $this->input->post();
		if($result)
		{
			redirect(base_url()."city/");
		}
	}
	public function cityLocalityActiveStatus()
	{   $cityId = $this->input->get('cityId');
		if($result)			
		{
			redirect(base_url()."city/getCityLocality?id=$cityId");
	    
	    }
	}
	public function editCityLocalityDetails()
	{	$cityLocalityId = $this->input->get('id');
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('edit_city_locality',$data);
			$this->load->view('include/footer');
	}
	public function cityLocalityDetailsUpdate()
	{
		$data = $this->input->post();
		$cityId = $this->input->post('cityid');
		if($result)			
		{
			redirect(base_url()."city/getCityLocality?id=$cityId");
	    
	    }
	}	
}
?>