<?php
class City extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('citymodel');			
		if(!isLoggedIn() || !isSuperAdmin())
         redirect('Login');	
	}
	
	public function addCityContent()
	{
		$cityId = $this->input->get('id');
		$data['cityList'] = $this->citymodel->getCity(1);
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_city',$data);
		$this->load->view('include/footer');
	}
	public function addCityPageContent()
	{
		$data = $this->input->post();
		$cityId = $this->input->get('id');
		if($result){
			redirect('city/');
		}
		
	}
	public function editCityContent()
	{
		$Id = $this->input->get('id');
		$data['cityList'] = $this->citymodel->getCity();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('edit_city',$data);
		$this->load->view('include/footer');
	}
	public function updateCityPageContent()
	{
		$data = $this->input->post();
		$Id = $this->input->get('cityDetailsId');
		if($result){
			redirect('city/');
		}
		
	}
	public function getCityContent()
	{
		$cityId = $this->input->get('id');
		$data['cityId'] = $cityId;
		$data['cityList'] = $this->citymodel->getCity();
		$data['cityLocality'] = $this->Seomodel->getCityLocality($cityId);
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('seoPageList',$data);
			$this->load->view('include/footer');
	}
	public function index()
	{
		$data['cityName'] = $this->citymodel->get_cities_bk();
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('view_city',$data);
			$this->load->view('include/footer');
	}
	public function getFeedBack()
	{       
        
	    $data['feedback'] = $this->citymodel->getManageFeedback();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('view_feedback_list',$data);
		$this->load->view('include/footer');		
	 
	    
	}
	public function feedbackActiveStatus()
	{       
	    $result = $this->citymodel->cancelFeedbackStatus($this->input->post());
		if($result)			
		{				
	    $data['feedback'] = $this->citymodel->getManageFeedback();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('view_feedback_list',$data);
		$this->load->view('include/footer');		
	 
	    }
	}	
	public function getCityLocality()
	{
		$cityId = $this->input->get('id');
		$data['cityId'] = $cityId;
		$data['cityList'] = $this->citymodel->get_cities_bk();
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('seocitylocality',$data);
			$this->load->view('include/footer');
	}
	public function addCityLocality()
	{
		$Cityid = $this->input->get('id');
		$data['CityId']= $Cityid;
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_city_locality', $data);
		$this->load->view('include/footer');
	}
	public function insertCityLocality()
	{
		$data = $this->input->post();
		if($result)
		{
			redirect(base_url()."city/");
		}
	}
	public function cityLocalityActiveStatus()
	{   $cityId = $this->input->get('cityId');
		if($result)			
		{
			redirect(base_url()."city/getCityLocality?id=$cityId");
	    
	    }
	}
	public function editCityLocalityDetails()
	{	$cityLocalityId = $this->input->get('id');
			$this->load->view('include/header');
			$this->load->view('include/breadcrum');
			$this->load->view('edit_city_locality',$data);
			$this->load->view('include/footer');
	}
	public function cityLocalityDetailsUpdate()
	{
		$data = $this->input->post();
		$cityId = $this->input->post('cityid');
		if($result)			
		{
			redirect(base_url()."city/getCityLocality?id=$cityId");
	    
	    }
	}	
}
?>