<?php

class Clinic extends CI_Controller {
	
       function __construct() {
       parent::__construct();
	   $this->load->model('Clinicmodel');
	   $this->load->model('Citymodel');
	   $this->load->model('doctor/Doctormodel');
		if(!isSuperAdmin())
				redirect('login');  
    }

   public function index()
   {
   $data['clinic'] = $this->Clinicmodel->getClinicRecords();
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('view_clinic_list',$data);
		$this->load->view('include/footer');
   
   }
   public function addClinic()
	{
		$data['city'] = $this->Citymodel->getCity();
		$data['state'] = $this->Citymodel->getState();
		$data['doctor'] = $this->Doctormodel->getDoctorRecords();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_clinic',$data);
		$this->load->view('include/footer');
	}
   public function submitClinic()
	{ 
        $data = $this->input->post();
		//echo "<pre>";print_r($result);die;
       
			$result=$this->Clinicmodel->addClinic($data);
			//echo "<pre>";print_r($data['services']);die;
			if($result){
				$this->session->set_flashdata('alert', 'Clinic Details inserted Successfully!');	
				redirect(base_url().'clinic');	
			}				
	}
	public function manageClinicDetails()
	{
        $data['clinic'] = $this->Clinicmodel->getClinicRecords();
		//echo "<pre>";print_r($data['services']);die;
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('view_clinic_list',$data);
		$this->load->view('include/footer'); 
	}
	public function editClinicDetails()
	{
		$data['city'] = $this->Citymodel->getCity();
		$data['state'] = $this->Citymodel->getState();
		$data['doctor'] = $this->Doctormodel->getDoctorRecords();
		$data['clinic'] = $this->Clinicmodel->getClinicRecords($this->input->get('Id'));
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('edit_clinic',$data);
		$this->load->view('include/footer'); 
	}
	public function updateClinic() 
	{
		$data= $this->input->post();
		$result = $this->Clinicmodel->updateClinic($data);
		if($result) 
		{
			$this->session->set_flashdata('alert', 'Clinic Details Updated Successfully!');	
			redirect(base_url().'clinic');
		}
	}
	public function deleteClinicInfo($id)
	{
	    
		$result = $this->Clinicmodel->deleteClinic($id);
		if($result)
		{
			$this->session->set_flashdata('alert',"Clinic Details Deleted Successfully");
			redirect(base_url()."clinic/manageClinicDetails?msg=delete");
		}
	}
	public function ActiveStatus(){
		$result = $this->Clinicmodel->ActiveStatus($this->input->post());
		if($result)			
		{				
	         redirect(base_url().'clinic');
	    }
	}
	public function getCityByStateId(){
        $stateId = $this->input->get('stateId');
        if($stateId){
            $data = $this->Doctormodel->getCityByStateId($stateId);
            if($data){
            //echo '<pre>'; print_r($data); die;
                $x = '<select>';
                foreach($data as $key => $val){
                    $x .='<option value="'.$val['city_id'].'">'.$val['city_name'].'</option>';
                }
                $x .='</select>';
                echo  $x;     die; 
            }
            echo  false;
        }
    }
   
   }
   ?>