<section class="content">
    <div class="row">
        <div class="col-md-12">
            <!-- Custom Tabs -->
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs" style="padding-left:37px;">
                    <li class="active"><a href="#tab_1" data-toggle="tab">Add New Doctor</a></li>
                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" id="tab_1">
                        <form role="form" id="doctor_validations" action="<?php echo base_url() . "doctor/submitDoctor" ?>"  enctype="multipart/form-data" method="post">
                            <div class="form-group">
                                <label>First Name</label>
                                <input type="text" name="doctor_fname" id="doctor_fname" class="form-control">
                            </div>	
                            <div class="form-group">
                                <label>Last Name</label>
                                <input type="text" name="doctor_lname" id="doctor_lname" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>Email</label>	
                                <input type="text" name="doctor_email" id="doctor_email" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>Mobile</label>
                                <input type="text" name="doctor_mobile" id="doctor_mobile" class="form-control" maxlength="10">
                            </div>
                            <div class="form-group">
                                <label>State</label>
                                <select class="form-control" name="doctor_state" id="doctor_state">
                                    <option value="" >-- Select State --</option>
                                    <?php foreach ($state as $stateDetails): ?>
                                        <option  value="<?php echo $stateDetails['state_id']; ?>"><?php echo $stateDetails['state_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>City</label>
                                <select class="form-control" name="doctor_city" id="doctor_city">
                                    <option value="" >-- Select City --</option>
                                    <?php foreach ($city as $cityDetails): ?>
                                        <option  value="<?php echo $cityDetails['city_id']; ?>"><?php echo $cityDetails['city_name']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Address</label>
                                <textarea  id="editor1" name="doctor_address" class="form-control"></textarea>
                                <!--input type="text" name="doctor_address" class="form-control"-->
                            </div>
                            <!--div class="form-group">
                                    <label for="inputProductPhoto">Image</label><span id="ProductPhoto" style="color:red;"></span>
                                    <input type="file" name="profile_image" id="inputProductPhoto">
                            </div-->
                            <center><input class="btn btn-success" type="submit" value="Submit" ></center>				
                        </form>
                    </div><!-- /.tab-pane -->
                </div><!-- /.tab-content -->
            </div><!-- nav-tabs-custom -->
        </div><!-- /.col -->
    </div><!--/.row -->

</section><!-- /.content -->

<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>
<script>

    $(document).ready(function () {
        $('#doctor_validations').submit(function (e) {
            var doctor_fname = $('#doctor_fname').val();
            var doctor_lname = $('#doctor_lname').val();
            var doctor_email = $('#doctor_email').val();
            var doctor_mobile = $('#doctor_mobile').val();
            var doctor_state = $('#doctor_state').val();
            var doctor_city = $('#doctor_city').val();
            var doctor_address = $('#doctor_address').val();

            $(".error").remove();

            if (doctor_fname.length < 1) {
                $('#doctor_fname').after('<span class="error">First Name is required</span>');
                $("#doctor_fname").focus();
                return false;
            }
            if (doctor_lname.length < 1) {
                $('#doctor_lname').after('<span class="error">Last Name is required</span>');
                $("#doctor_lname").focus();
                return false;
            }
            if (doctor_email.length < 1) {
                $('#doctor_email').after('<span class="error">Email is required</span>');
                $("#doctor_email").focus();
                return false;
            }
			if (doctor_email.length < 1) {
				  $('#doctor_email').after('<span class="error">You cant leave email empty</span>');
				  return false;
				} else {
				  var regEx2 = /^([a-zA-Z0-9_\-\.]+)@([a-zA-Z0-9_\-\.]+)\.([a-zA-Z]{2,5})$/;
				  var validEmail = regEx2.test(doctor_email);
				 if (!validEmail) {
				  $('#doctor_email').after('<span class="error">Invalid email</span>');
				  $("#doctor_email").focus();
				  return false;
				}
			   }
            if (doctor_mobile.length != 10) {
				  $('#doctor_mobile').after('<span class="error">You cant leave mobile number empty</span>');
				  return false;
				} else {
				  var regEx1 = /^[1-9]{1}[0-9]{9}$/;
				  var validMobile = regEx1.test(doctor_mobile);
				 if (!validMobile) {
				  $('#doctor_mobile').after('<span class="error">Invalid mobile number</span>');
				  $("#doctor_mobile").focus();
				  return false;
				}
			   }
            if (doctor_state.length < 1) {
                $('#doctor_state').after('<span class="error">State is required</span>');
                $("#doctor_state").focus();
                return false;
            }
            if (doctor_city.length < 1) {
                $('#doctor_city').after('<span class="error">City is required</span>');
                $("#doctor_city").focus();
                return false;
            }
            if (document.getElementById('doctor_address').value == '') {
                $('#doctor_address').after('<span class="error">Address is required</span>');
                $("#doctor_address").focus();
                return false;
            }
            if (document.getElementById('editor1').value == "") {
                $('#editor1').after('<span class="error">You cant leave address empty</span>');
                $("#editor1").focus();
                return false;
            }

        });

    });
    $('#doctor_state').change(function () {
    var stateId = this.value;
        $.ajax({url: "<?php echo base_url(); ?>doctor/getCityByStateId?stateId="+stateId, success: function (result) {
            console.log(result);
            $("#doctor_city").html(result);
        }});
    });
</script>

