<?php

class Doctor extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('Doctormodel');
        $this->load->model('Citymodel');
        if (!isSuperAdmin())
            redirect('login');
    }

    public function index() {
        $data['doctor'] = $this->Doctormodel->getDoctorRecords();

        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_doctor_list', $data);
        $this->load->view('include/footer');
    }

    public function addDoctor() {

        $data['city'] = $this->Citymodel->getCity();
        $data['state'] = $this->Citymodel->getState();
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('add_doctor', $data);
        $this->load->view('include/footer');
    }

    public function submitDoctor() {
        $result = $this->input->post();
        //echo "<pre>";print_r($result);die;
        if (!$this->Doctormodel->getDoctorRecords('', $mobileNo = $result['doctor_mobile'])) {
            $this->Doctormodel->addDoctor($result);
            if ($result) {
                $this->session->set_flashdata('alert', "Doctor Details Inserted Successfully");
                redirect(base_url() . 'doctor');
            }
        } else {
            $this->session->set_flashdata('alert', "This Mobile Number is already exist!");
            redirect(base_url() . 'doctor');
        }
    }

    public function manageDoctorDetails() {

        $data['doctor'] = $this->Doctormodel->getDoctorRecords();
        //echo "<pre>";print_r($data['services']);die;
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('view_doctor_list', $data);
        $this->load->view('include/footer');
    }

    public function editDoctorDetails() {
        $data['doctor'] = $this->Doctormodel->getDoctorRecords($this->input->get('Id'));
        //echo "<pre>";print_r($data['doctor']);die;
        $this->load->view('include/header');
        $this->load->view('include/breadcrum');
        $this->load->view('edit_doctor', $data);
        $this->load->view('include/footer');
    }

    public function updateDoctor() {
        $data = $this->input->post();
        $result = $this->Doctormodel->updateDoctor($data);
        if ($result) {
            $this->session->set_flashdata('alert', "Doctor Details Update Successfully");
            redirect(base_url() . 'doctor');
        }
    }

    public function deleteDoctorInfo($id) {

        $result = $this->Doctormodel->deleteDoctor($id);
        if ($result) {
            redirect(base_url() . "doctor/manageDoctorDetails?msg=delete");
        }
    }

    public function ActiveStatus() {
        $result = $this->Doctormodel->ActiveStatus($this->input->post());
        if ($result) {
            redirect(base_url() . 'doctor');
        }
    }
    public function getCityByStateId(){
        $stateId = $this->input->get('stateId');
        if($stateId){
            $data = $this->Doctormodel->getCityByStateId($stateId);
            if($data){
            //echo '<pre>'; print_r($data); die;
                $x = '<select>';
                foreach($data as $key => $val){
                    $x .='<option value="'.$val['city_id'].'">'.$val['city_name'].'</option>';
                }
                $x .='</select>';
                echo  $x;     die; 
            }
            echo  false;
        }
    }

}

?>