<?php
class Patient extends CI_Controller {
	
       function __construct() {
       parent::__construct();
	   $this->load->model('Patientmodel');
	   $this->load->model('Citymodel');
	   $this->load->model('doctor/Doctormodel');
		if(!isSuperAdmin())
				redirect('login');  
    }
   public function index()
   {
	  
		$data['patient'] = $this->Patientmodel->getPatientRecords();
		
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('view_patient_list',$data);
		$this->load->view('include/footer');
   }
   public function addPatient()
	{
		$data['city'] = $this->Citymodel->getCity();
		$data['state'] = $this->Citymodel->getState();
		$data['doctor'] = $this->Doctormodel->getDoctorRecords();
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_patient',$data);
		$this->load->view('include/footer');
	}
   public function submitPatient()
	{ 
        $result = $this->input->post();
		//echo "<pre>";print_r($result);die;
		if(!$this->Patientmodel->getPatientRecords('',$patientId = $result['patient_id'])){
			$this->Patientmodel->addPatient($result);
			if($result){
				$this->session->set_flashdata('alert',"Patient Details Inserted Successfully");
				redirect(base_url().'patient');	
			}
		}else{
			$this->session->set_flashdata('alert',"This PatientId is already exist!");
			redirect(base_url().'patient');
		}	
	}
	public function managePatientDetails()
	{
	    
        $data['patient'] = $this->Patientmodel->getPatientRecords();
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('view_patient_list',$data);
		$this->load->view('include/footer'); 
	}
	public function editPatientDetails()
	{
		$data['city'] = $this->Citymodel->getCity();
		$data['doctor'] = $this->Doctormodel->getDoctorRecords('','',$status=1);
		$data['patient'] = $this->Patientmodel->getPatientRecords($this->input->get('Id'));
		//echo "<pre>";print_r($data['patient']);die;
		$this->load->view('include/header'); 
		$this->load->view('include/breadcrum'); 
		$this->load->view('edit_patient',$data);
		$this->load->view('include/footer'); 
	}
	public function updatePatient() 
	{
		$data= $this->input->post();
		$result = $this->Patientmodel->updatePatient($data);
		if($result) 
		{
			$this->session->set_flashdata('alert', 'Patient Details Update Successfully!');	
			redirect(base_url().'patient');
		}else{
			$this->session->set_flashdata('alert',"No changes done!");
			redirect(base_url().'patient');
		}	
	}
	public function deletePatientInfo($id)
	{
		$result = $this->Patientmodel->deletePatient($id);
		if($result)
		{
			redirect(base_url()."doctor/managePatientDetails?msg=delete");
		}
	}
	public function ActiveStatus(){
		$result = $this->Patientmodel->ActiveStatus($this->input->post());
		if($result)			
		{				
	         redirect(base_url().'patient');
	    }
	}
   }
   ?>