<?php
class User extends CI_Controller
{
	function __construct()
	{
		parent::__construct();
		$this->load->model('Usermodel');
		
		$this->load->helper('common');
		$this->load->helper('user');
		$this->load->library('session');
		if(isLoggedIn())
		{
			return true;
		}else{ 
				redirect('dashboard');
        }
			
	}
	public function index()
	{
		$data['user']=$this->Usermodel->getUser();
		
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('view_user_list');
		$this->load->view('include/footer');
		
	}
	
	public function addUser()
	{
		$this->load->view('include/header');
		$this->load->view('include/breadcrum');
		$this->load->view('add_user');
		$this->load->view('include/footer');
	}
	public function viewUser()
	{
	     
	    $data['user']=$this->Usermodel->getUserId();
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('view_user');
		$this->load->view('include/footer');
	}
	public function editUser()
	{
	    $data['user']=$this->Usermodel->getUserId();
		$this->load->view('include/header',$data);
		$this->load->view('include/breadcrum');
		$this->load->view('edit_user');
		$this->load->view('include/footer');
	}
	
	public function getUserDetails()
	{
	    //echo "<pre>";print_r($_FILES);die;
		$attachment ="";
		$data = $this->input->post();
		//echo "<pre>";print_r($data);die;
		$this->load->library('upload');
		if($data)
		{	
		
		  if($_FILES['profile_photo_att']['name'] !="")
		    {
				$fieldName = 'profile_photo_att';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'profile_photo_att_'.time().'.'.$ext;
				//echo "<pre>";print_r($attachment);die;
				$this->upload->initialize($this->set_upload_options($attachment));
				
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success"; //die;
			}
			else
			{
				$error = array('error' => $this->upload->display_errors());
				
			}
			
			    //print_r($_FILES); die;
			}
			    $data['profile_photo_att'] = $attachment;
				//echo "<pre>";print_r($data);die;
			    $result = $this->Usermodel->addUser($data);
			   // echo "<pre>";print_r($result);die;
			if($result)
			{	
				$this->session->set_flashdata('alert', 'Clinic Details Added Successfully!');	
				$data['user']=$this->Usermodel->getUser();
				$this->load->view('include/header',$data);
				//$this->load->view('include/header');
				$this->load->view('include/breadcrum');
				$this->load->view('view_user_list');
				$this->load->view('include/footer');
			}
		}
    }
	public function updateUserDetails()
	{
	  $data = $this->input->post();
	 $file=$_FILES;
		//echo "<pre>"; print_r($file); die;
		if(empty($_FILES['profile_photo_att']['name']))
		{
			  $result = $this->Usermodel->userUpdateWi($data);
			  //echo "<pre>"; print_r($result); die;
		    if($result)
		    {
			  $this->session->set_flashdata('alert', 'User Details Updated Successfully!');	
			  redirect(base_url().'user');
			}
		
		}
		if(!empty($_FILES['profile_photo_att']['name']))
		{
			
		   $this->load->library('upload');
		
			if($_FILES['profile_photo_att'])
			{
				$fieldName = 'profile_photo_att';
				$ext = pathinfo($_FILES[$fieldName]['name'], PATHINFO_EXTENSION);
				$attachment = 'profile_photo_att_'.time().'.'.$ext;
				//echo "<pre>"; print_r($attachment); die;
				$this->upload->initialize($this->set_upload_options($attachment));
				
			if($this->upload->do_upload($fieldName))
			{
				$msg = "upload success"; //die;
			}
			else
			{
				$error['msg']=$this->upload->display_error();
				
			}
			    $data['profile_photo_att'] = $attachment;
			    //echo "<pre>"; print_r($data['profile_photo_att']); die;
			}
			if(!@$error)
			{
				 $result = $this->Usermodel->updateUser($data);
				  //echo "<pre>"; print_r($result); die;
		    if($result)
		    {	
			    
			  redirect(base_url().'user');
			}
			}
			else
			{
				$this->load->view('view_user_list',$error);
			}
		}
	}
	private function set_upload_options($imageName)
	{   
		//upload an image options
		$config = array();
		$config['upload_path'] = 'upload/';
		$config['allowed_types'] = 'gif|jpg|png|pdf';
		$config['max_size']      = '10000KB';
		$config['overwrite']     = FALSE;
		$config['file_name']	 = $imageName;

		return $config;
	}
	public function userActiveStatus()
	{       
	    $result = $this->Usermodel->cancelUserStatus($this->input->post());
	    //echo "<pre>"; print_r($result);die;
		if($result)			
		{				
	            
			  redirect(base_url().'user');
	 
	    }
	}
	
}