<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Boxes extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Boxesmodel');
        $this->load->model('Ordermodel');
        $this->load->model('Productsmodel');
        $this->load->model('Usermodel');
        $this->load->library('session');
        $this->load->library('cart');
    }

    public function getboxes() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['id'] = $this->input->post('id', TRUE);
            $inputData['filter'] = $this->input->post('filter', TRUE);
            $input_data = json_decode($json, TRUE);

            if (!$inputData['id'] && !empty($input_data)) {
                $inputData['id'] = $input_data['id'];
            }
            if (!$inputData['filter'] && !empty($input_data)) {
                $inputData['filter'] = $input_data['filter'];
            }

            if (!empty($inputData['id'])) {
                $session = array();
                $res = $this->Boxesmodel->getboxes($status = 1, $inputData['filter']);
                $sessionData = $this->cart->contents();
                foreach ($res as $key => $values) {
                    $res[$key]['package_price'] = round($values['package_price']);
                    $res[$key]['package_image_app'] = base_url() . 'upload/' . $values['package_image'];
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $id = str_ireplace("p", "", $list['id']);
                            if ($id == $values['id_package']) {
                                $session[$key]['id'] = $id;
                                $session[$key]['name'] = $list['name'];
                                $session[$key]['unitvalue'] = $list['unitvalue'];
                                $session[$key]['unitprice'] = $list['unitprice'];
                                $session[$key]['price'] = $list['price'];
                                $session[$key]['qty'] = $list['qty'];
                                $session[$key]['rowid'] = $list['rowid'];
                            }
                        }
                        $session = array_values($session);
                    } else {
                        $session = array();
                    }
                }
                $banner = array(
                    'banner' => base_url() . 'public/images/boxesbanner1.jpg',
                    'title' => 'Subscription Boxes',
                    'description' => "Eating healthy is a commitment, subscribe to monthly subscription boxes and get a healthy dose of Fresh, Seasonal, Authentic Organic produce from the farm uninterrupted.",
                );
                $result['Success'] = "TRUE";
                $result['Message'] = 'List Of Boxes';
                $result['Result'] = $res;
                $result['Banner'] = $banner;
                $result['Session'] = ($session);
                die(json_encode($result));
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    public function updateBoxQuantity() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['productType'] = $this->input->post('productType', TRUE);
            $inputData['packId'] = $this->input->post('packId', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['productType'] && !empty($input_data)) {
                $inputData['productType'] = $input_data['productType'];
            }

            if (!$inputData['packId'] && !empty($input_data)) {
                $inputData['packId'] = $input_data['packId'];
            }
            $inputData['id'] = $inputData['packId'];
            if (!empty($inputData['packId']) && !empty($inputData['productType'])) {
                $sessionp = $this->session->userdata('boxproductsreplace');
                $sessionData = $this->cart->contents();
                if ($sessionData) {
                    foreach ($sessionData as $key => $list) {
                        $id = str_ireplace("p", "", $list['id']);
                        if ($id == $inputData['packId'] && $list['type'] == 'box') {
                            if ($productjson = $list['productjson']) {
                                foreach ($productjson as $pkey => $plist) {
                                    if (isset($plist['products'])) {
                                        $res['productDetails']['products']['products'] = $plist['products'];
                                    }
                                    if (isset($plist['products2'])) {
                                        $res['productDetails']['products2']['products2'] = $plist['products2'];
                                    }
                                    if (isset($plist['products3'])) {
                                        $res['productDetails']['products3']['products3'] = $plist['products3'];
                                    }
                                    if (isset($plist['products4'])) {
                                        $res['productDetails']['products4']['products4'] = $plist['products4'];
                                    }
                                    if (isset($plist[$inputData['productType']])) {
                                        
                                    } else {
                                        if ($package = $this->Ordermodel->packagelist($inputData['id'])) {
                                            $flag = false;
                                            $products = json_decode($package[0]['products'], true);
                                            if ($products) {
                                                if ($inputData['productType'] == 'products') {
                                                    foreach ($products as $keys => $value) {
                                                        if (isset($sessionp['boxproductsreplace'][$inputData['id']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products[$keys]['productname'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype1']['replaceproduct']['replaceproductname'][$value['productid']];
                                                            ;
                                                            $products[$keys]['productid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype1']['replaceproduct']['replaceproductid'][$value['productid']];
                                                            $products[$keys]['productqty'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype1']['replaceproduct']['replaceproductqty'][$value['productid']];
                                                            $products[$keys]['oldproductid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']];
                                                        } else {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products[$keys]['productid'] = $value['productid'];
                                                            $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                                            $products[$keys]['productqty'] = $value['productqty'];
                                                            $products[$keys]['oldproductid'] = '';
                                                        }
                                                    }
                                                    $flag = true;
                                                    $res['productDetails']['products']['products'] = $products;
                                                }
                                            }

                                            $products2 = json_decode($package[0]['products2'], true);
                                            if ($products2) {
                                                if ($inputData['productType'] == 'products2') {
                                                    foreach ($products2 as $keys2 => $value) {
                                                        if (isset($sessionp['boxproductsreplace'][$inputData['id']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products2[$keys2]['productname'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype2']['replaceproduct']['replaceproductname'][$value['productid']];
                                                            ;
                                                            $products2[$keys2]['productid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype2']['replaceproduct']['replaceproductid'][$value['productid']];
                                                            $products2[$keys2]['productqty'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype2']['replaceproduct']['replaceproductqty'][$value['productid']];
                                                            $products2[$keys2]['oldproductid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']];
                                                        } else {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products2[$keys2]['productid'] = $value['productid'];
                                                            $products2[$keys2]['productname'] = $pdetail[0]['product_name'];
                                                            $products2[$keys2]['productqty'] = $value['productqty'];
                                                            $products2[$keys2]['oldproductid'] = '';
                                                        }
                                                    }
                                                    $flag = true;
                                                    $res['productDetails']['products2']['products2'] = $products2;
                                                }
                                            }

                                            $products3 = json_decode($package[0]['products3'], true);
                                            if ($products3) {
                                                if ($inputData['productType'] == 'products3') {
                                                    foreach ($products3 as $keys3 => $value) {
                                                        if (isset($sessionp['boxproductsreplace'][$inputData['id']]['producttype3']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products3[$keys3]['productname'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype3']['replaceproduct']['replaceproductname'][$value['productid']];
                                                            ;
                                                            $products3[$keys3]['productid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype3']['replaceproduct']['replaceproductid'][$value['productid']];
                                                            $products3[$keys3]['productqty'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype3']['replaceproduct']['replaceproductqty'][$value['productid']];
                                                            $products3[$keys3]['oldproductid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype3']['replacedproduct']['replacedproductid'][$value['productid']];
                                                        } else {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products3[$keys3]['productid'] = $value['productid'];
                                                            $products3[$keys3]['productname'] = $pdetail[0]['product_name'];
                                                            $products3[$keys3]['productqty'] = $value['productqty'];
                                                            $products3[$keys3]['oldproductid'] = '';
                                                        }
                                                    }
                                                    $flag = true;
                                                    $res['productDetails']['products3']['products3'] = $products3;
                                                }
                                            }



                                            $products4 = json_decode($package[0]['products4'], true);
                                            if ($products4) {
                                                if ($inputData['productType'] == 'products4') {
                                                    foreach ($products4 as $keys4 => $value) {
                                                        if (isset($sessionp['boxproductsreplace'][$inputData['id']]['producttype4']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products4[$keys4]['productname'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype4']['replaceproduct']['replaceproductname'][$value['productid']];
                                                            ;
                                                            $products4[$keys4]['productid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype4']['replaceproduct']['replaceproductid'][$value['productid']];
                                                            $products4[$keys4]['productqty'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype4']['replaceproduct']['replaceproductqty'][$value['productid']];
                                                            $products4[$keys4]['oldproductid'] = $sessionp['boxproductsreplace'][$inputData['id']]['producttype4']['replacedproduct']['replacedproductid'][$value['productid']];
                                                        } else {
                                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                                            $products4[$keys4]['productid'] = $value['productid'];
                                                            $products4[$keys4]['productname'] = $pdetail[0]['product_name'];
                                                            $products4[$keys4]['productqty'] = $value['productqty'];
                                                            $products4[$keys4]['oldproductid'] = '';
                                                        }
                                                    }
                                                    $flag = true;
                                                    $res['productDetails']['products4']['products4'] = $products4;
                                                }
                                            }


                                            $productJson = $res['productDetails'];
                                            $length = count($productJson);
                                            $daysCount = count($this->session->userdata('boxdeliverydays'));
                                            if (!$daysCount) {
                                                $daysCount = 0;
                                            }
                                            $session['productjson'] = $productJson;
                                            /* if($flag == true){
                                              if($length == 0){
                                              $q = 0;
                                              }else{
                                              $q = $list['qty'] + 1;
                                              }
                                              }else{
                                              $q = $list['qty'];
                                              } */

                                            if ($length == 0) {
                                                $q = 0;
                                            } else {
                                                $q = $length * $daysCount;
                                            }
                                            $insert_room = array(
                                                'id' => 'p' . $inputData['id'],
                                                'qty' => $q,
                                                'rowid' => $key,
                                                'price' => $list['price'],
                                                'unitprice' => $package[0]['package_price'],
                                                'unitvalue' => 1,
                                                'gstprice' => $package[0]['package_gst_tax'],
                                                'type' => 'box',
                                                'productjson' => $session['productjson'],
                                            );
                                            $this->cart->update($insert_room);

                                            $d = $this->cart->contents();
                                            $data['id'] = $inputData['id'];
                                            $data['name'] = $d[$key]['name'];
                                            $data['price'] = $d[$key]['price'];
                                            $data['unitprice'] = $d[$key]['unitprice'];
                                            $data['rowid'] = $d[$key]['rowid'];
                                            $data['qty'] = $d[$key]['qty'];
                                            $data['length'] = $length;
                                            $data['gstprice'] = $d[$key]['gstprice'];
                                            //}

                                            $result['Success'] = "TRUE";
                                            $result['Message'] = 'Item added successfully into cart';
                                            $result['RowId'] = $key;
                                            $result['Result'] = $data;
                                        }
                                    }
                                }
                            }
                        }
                    }

                    die(json_encode($result));
                } else {
                    $session = array();

                    $result['Success'] = "False";
                    $result['Message'] = 'Add package into cart first!';
                    //	$result['Result'] =$res;
                    $result['Session'] = ($session);
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    public function removeBoxQuantity() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['productType'] = $this->input->post('productType', TRUE);
            $inputData['packId'] = $this->input->post('packId', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['productType'] && !empty($input_data)) {
                $inputData['productType'] = $input_data['productType'];
            }

            if (!$inputData['packId'] && !empty($input_data)) {
                $inputData['packId'] = $input_data['packId'];
            }
            $inputData['id'] = $inputData['packId'];
            if (!empty($inputData['packId']) && !empty($inputData['productType'])) {
                $session = array();
                $flag = false;
                //	$res = $this->Boxesmodel->getboxes($status = 1);
                $sessionp = $this->session->userdata('boxproductsreplace');
                $sessionData = $this->cart->contents();
                //	echo "<pre>"; print_r($sessionData); die;
                if ($sessionData) {
                    foreach ($sessionData as $key => $list) {
                        $id = str_ireplace("p", "", $list['id']);
                        if ($id == $inputData['packId'] && $list['type'] == 'box') {
                            $qty = $list['qty'];
                            if ($list['productjson']) {
                                foreach ($list['productjson'] as $jpkey => $jpvalue) {
                                    if (isset($jpvalue['products'])) {
                                        if ($inputData['productType'] == 'products') {
                                            unset($sessionData[$key]['productjson'][$jpkey]);
                                        }
                                    }
                                    if (isset($jpvalue['products2'])) {
                                        if ($inputData['productType'] == 'products2') {
                                            unset($sessionData[$key]['productjson'][$jpkey]);
                                        }
                                    }
                                    if (isset($jpvalue['products3'])) {
                                        if ($inputData['productType'] == 'products3') {
                                            unset($sessionData[$key]['productjson'][$jpkey]);
                                        }
                                    }
                                    if (isset($jpvalue['products4'])) {
                                        if ($inputData['productType'] == 'products4') {
                                            unset($sessionData[$key]['productjson'][$jpkey]);
                                        }
                                    }
                                }
                                $sessionData[$key]['productjson'] = array_values($sessionData[$key]['productjson']);
                            }
                            $result['Success'] = "TRUE";
                            $result['Message'] = 'List Of Boxes';
                            $flag = true;

                            $session = array_values($session);
                            $length = count($sessionData[$key]['productjson']);
                            $daysCount = count($this->session->userdata('boxdeliverydays'));
                            if (!$daysCount) {
                                $daysCount = 0;
                            }
                            if ($length == 0) {
                                $q = 0;
                            } else {
                                $q = $length * $daysCount;
                            }
                            //echo $q; die;

                            $data = array(
                                'rowid' => $key,
                                'productjson' => $sessionData[$key]['productjson'],
                                'qty' => $q,
                                'id' => $id,
                                'name' => $list['name'],
                            );

                            $this->cart->update($data);
                        } else {
                            $result['Success'] = "False";
                            $result['Message'] = 'Add package into cart first!';
                            $result['Result'] = $sessionData;
                            $result['Session'] = $this->cart->contents();
                            ;
                            $result['OldData'] = array();
                            //	die(json_encode($result));
                        }
                    }
                } else {
                    $session = array();
                }

                //	$sessionp = $this->session->userdata('boxproductsreplace'); 

                $result['Result'] = $this->cart->contents();
                $result['flag'] = $flag;
                if ($data['qty'] == 0) {
                    $result['Success'] = "FALSE";
                }
                $result['OldData'] = $data;

                die(json_encode($result));
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    public function getboxdetails() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['ProductUrl'] = $this->input->post('ProductUrl', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['ProductUrl'] && !empty($input_data)) {
                $inputData['ProductUrl'] = $input_data['ProductUrl'];
            }

            if (($inputData['ProductUrl'])) {
                $res['productDetails'] = $this->Boxesmodel->getboxdetails($inputData['ProductUrl']);
                $productids = array();
                if ($res['productDetails']) {
                    foreach ($res['productDetails'] as $key => $values) {
                        if ($values['products_name']) {
                            $res['productDetails'][$key]['products_name_app'] = json_decode($values['products_name'], true);
                        } else {
                            $res['productDetails'][$key]['products_name_app'] = array();
                        }
                        $products = json_decode($values['products'], true);
                        if ($products) {
                            foreach ($products as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products[$keys]['productname'] = '';
                                    $products[$keys]['productimg'] = '';
                                }
                                $products[$keys]['productqty'] = $value['productqty'];
                                $products[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products'] = $products;
                        $products2 = json_decode($values['products2'], true);
                        if ($products2) {
                            foreach ($products2 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products2[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products2[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products2[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products2[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products2[$keys]['productname'] = '';
                                    $products2[$keys]['productimg'] = '';
                                }
                                $products2[$keys]['productqty'] = $value['productqty'];
                                $products2[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products2'] = $products2;
                        $products3 = json_decode($values['products3'], true);
                        if ($products3) {
                            foreach ($products3 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products3[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products3[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products3[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products3[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products3[$keys]['productname'] = '';
                                    $products3[$keys]['productimg'] = '';
                                }
                                $products3[$keys]['productqty'] = $value['productqty'];
                                $products3[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products3'] = $products3;
                        $products4 = json_decode($values['products4'], true);
                        if ($products4) {
                            foreach ($products4 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products4[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products4[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products4[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products4[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products4[$keys]['productname'] = '';
                                    $products4[$keys]['productimg'] = '';
                                }
                                $products4[$keys]['productqty'] = $value['productqty'];
                                $products4[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products4'] = $products4;
                    }
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $res['productDetails'][0]['id_package']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                                $session['productjson'] = $list['productjson'];
                            }
                        }
                    } else {
                        $session = '';
                    }
                    $userData = $this->session->userdata('userid');
                    //	echo $userData; die;
                    if ($userData) {
                        $favData = $this->Productsmodel->addtofav($userData);
                        $usrdata['favProd'] = json_decode($favData[0]['fav_content'], true);
                        if ($usrdata['favProd']) {
                            if (in_array($res['productDetails'][0]['id_package'], $usrdata['favProd'])) {
                                $usrdata['is_fav'] = 'yes';
                            } else {
                                $usrdata['is_fav'] = 'no';
                            }
                        } else {
                            $usrdata['favProd'] = '';
                        }
                    } else {
                        $usrdata['favProd'] = '';
                    }
                    if ($productids) {
                        $res['recipes'] = $this->Productsmodel->recipesList($productids);
                    } else {
                        $res['recipes'] = '';
                    }
                }
                $boxsession = '';
                if ($boxinsession = $this->session->userdata('boxproductsreplace')) {
                    $boxsession = $boxinsession;
                }

                if ($res['productDetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Category wise product list.';
                    $result['Result'] = $res;
                    //	$result['recipes'] = array_unique($productids);
                    $result['Session'] = $session;
                    $result['usrdata'] = $usrdata;
                    $result['boxsession'] = $boxsession;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

/*
      function getalternateproducts(){
      $json = trim(file_get_contents('php://input'));
      if(!empty($json)){
      $inputData['productid'] =  $this->input->post('productid', TRUE);

      $input_data = json_decode($json, TRUE);

      if(!$inputData['productid'] && !empty($input_data)){
      $inputData['productid'] = $input_data['productid'];
      }

      if(!empty($inputData['productid'])){
      $res = $this->Productsmodel->productdetailsbyid($inputData['productid']);
      if($res){
      foreach($res as $key => $items){
      $products = $this->Productsmodel->productdetailsbyids(json_decode($items['alternate_prroducts'],true));
      }
      }else{
      $products = '';
      }
      $result['Success'] = "TRUE";
      $result['Message'] = 'List Of products';
      $result['Result'] =$products;
      die(json_encode($result));
      }else{
      $result['Success'] = "False";
      $result['Message'] = 'Parameters are incorrect';
      die(json_encode($result));
      }

      }else{
      $result['Success'] = "FALSE";
      $result['Message'] = 'Invalid resquest';
      die(json_encode($result));
      }
      } */

    function getalternateproducts() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['productid'] = $this->input->post('productid', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['productid'] && !empty($input_data)) {
                $inputData['productid'] = $input_data['productid'];
            }
 
            if (!empty($inputData['productid'])) {
                $inputData['productid'] = explode(',', $inputData['productid']);
                $inputData['productid'] = json_encode($inputData['productid']);
                $products = $this->Productsmodel->productdetailsbyids(json_decode($inputData['productid'], true));
                //	echo "<pre>"; print_r($products); die;
                
                if ($products) {
                    foreach($products as $key => $val){
                        $products[$key]['product_actual_imgAPP'] = base_url().'upload/'.$val['product_actual_img'];
                    }
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'List Of products';
                    $result['Result'] = $products;
                    die(json_encode($result));
                } else {
                    $products = '';
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No product found yet!';
                    $result['Result'] = $products;
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    function setreplacedproduct() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['img'] = $this->input->post('img', TRUE);
            $inputData['name'] = $this->input->post('name', TRUE);
            $inputData['oldproname'] = $this->input->post('oldproname', TRUE);
            $inputData['newproid'] = $this->input->post('newproid', TRUE);
            $inputData['oldproid'] = $this->input->post('oldproid', TRUE);
            $inputData['oldproqty'] = $this->input->post('oldproqty', TRUE);
            $inputData['boxid'] = $this->input->post('boxid', TRUE);
            $inputData['producttype'] = $this->input->post('producttype', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['name'] && !empty($input_data)) {
                $inputData['name'] = $input_data['name'];
            }

            if (!$inputData['img'] && !empty($input_data)) {
                $inputData['img'] = $input_data['img'];
            }
            if (!$inputData['oldproname'] && !empty($input_data)) {
                $inputData['oldproname'] = $input_data['oldproname'];
            }
            if (!$inputData['oldproqty'] && !empty($input_data)) {
                $inputData['oldproqty'] = $input_data['oldproqty'];
            }
            if (!$inputData['newproid'] && !empty($input_data)) {
                $inputData['newproid'] = $input_data['newproid'];
            }

            if (!$inputData['oldproid'] && !empty($input_data)) {
                $inputData['oldproid'] = $input_data['oldproid'];
            }

            if (!$inputData['boxid'] && !empty($input_data)) {
                $inputData['boxid'] = $input_data['boxid'];
            }

            if (!$inputData['producttype'] && !empty($input_data)) {
                $inputData['producttype'] = $input_data['producttype'];
            }

            if (!empty($inputData['img']) && !empty($inputData['name']) && !empty($inputData['oldproname']) && !empty($inputData['oldproqty']) && !empty($inputData['newproid']) && !empty($inputData['oldproid']) && !empty($inputData['boxid']) && !empty($inputData['producttype'])) {
                $res = $this->Boxesmodel->getboxdetailsById($inputData['boxid']);
                if ($res) {
                    $products['boxproductsreplace'][$inputData['boxid']] = array(
                        'boxid' => $inputData['boxid'],
                        'producttype' . $inputData['producttype'] => array(
                            'replacedproduct' => array(
                                'replacedproductid' => array(
                                    $inputData['oldproid'] => ($inputData['oldproid'])
                                ),
                                'replacedproductname' => array(
                                    $inputData['oldproid'] => ($inputData['oldproname'])
                                ),
                                'replacedproductqty' => array(
                                    $inputData['oldproid'] => ($inputData['oldproqty'])
                                ),
                            ),
                            'replaceproduct' => array(
                                'replaceproductid' => array(
                                    $inputData['oldproid'] => $inputData['newproid']
                                ),
                                'replaceproductname' => array(
                                    $inputData['oldproid'] => $inputData['name']
                                ),
                                'replaceproductqty' => array(
                                    $inputData['oldproid'] => $inputData['oldproqty']
                                ),
                                'replaceproductimg' => array(
                                    $inputData['oldproid'] => $inputData['img']
                                ),
                            ),
                        ),
                    );

                    $session = $products;
                    if ($s = $this->session->userdata('boxproductsreplace')) {

                        if ($s['boxproductsreplace'][$inputData['boxid']]) {
                            if (!isset($s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductid'][$inputData['oldproid']])) {


                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductid'][$inputData['oldproid']] = $inputData['oldproid'];
                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductname'][$inputData['oldproid']] = $inputData['oldproname'];
                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductqty'][$inputData['oldproid']] = $inputData['oldproqty'];
//$s['boxproductsreplace'][$inputData['boxid']]['producttype'.$inputData['producttype']]['replacedproduct']['replaceproductimg'][$inputData['oldproid']] = $inputData['img']; 
                                $this->session->set_userdata('boxproductsreplace', $s);
                            }
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductid'][$inputData['oldproid']] = $inputData['newproid'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductname'][$inputData['oldproid']] = $inputData['name'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductqty'][$inputData['oldproid']] = $inputData['oldproqty'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductimg'][$inputData['oldproid']] = $inputData['img'];
                            $this->session->set_userdata('boxproductsreplace', $s);
                        }
                    } else {
                        $this->session->set_userdata('boxproductsreplace', $session);
                    }

                    $d = $this->session->userdata('boxproductsreplace');
                    //			echo "<pre>"; print_r($d); die;
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $inputData['boxid']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                                $products = json_decode($res[0]['products'], true);
                                if ($products) {
                                    foreach ($products as $keys => $value) {

                                        if (isset($d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']])) {

                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products[$keys]['productname'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductname'][$value['productid']];
                                            ;
                                            $products[$keys]['productid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductid'][$value['productid']];

                                            $products[$keys]['productqty'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductqty'][$value['productid']];
                                            $products[$keys]['oldproductid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']];
                                        } else {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products[$keys]['productid'] = $value['productid'];
                                            $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                            $products[$keys]['productqty'] = $value['productqty'];
                                            $products[$keys]['oldproductid'] = '';
                                        }
                                    }
                                }
                                $res['productDetails'][0]['products'] = $products;
                                $products2 = json_decode($res[0]['products2'], true);
                                if ($products2) {
                                    foreach ($products2 as $keys => $value) {
                                        if (isset($d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products2[$keys]['productname'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductname'][$value['productid']];
                                            ;
                                            $products2[$keys]['productid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductid'][$value['productid']];

                                            $products2[$keys]['productqty'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductqty'][$value['productid']];
                                            $products2[$keys]['oldproductid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']];
                                        } else {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products2[$keys]['productid'] = $value['productid'];
                                            $products2[$keys]['productname'] = $pdetail[0]['product_name'];
                                            $products2[$keys]['productqty'] = $value['productqty'];
                                            $products2[$keys]['oldproductid'] = '';
                                        }
                                    }
                                }
                                $res['productDetails'][1]['products2'] = $products2;
                                $productJson = $res['productDetails'];
                                $session['productjson'] = $productJson;
                                $dataa = array(
                                    'rowid' => $list['rowid'],
                                    'productjson' => $session['productjson']
                                );
                                $this->cart->update($dataa);
                            }
                        }
                    } else {
                        $session = '';
                    }

                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Added successfully';
                    $result['Result'] = $d;
                    $result['Session'] = $session;
                    die(json_encode($result));
                } else {
                    $products = '';
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Invalid Box Id!';
                    $result['Result'] = $products;
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

     
    public function getboxdetailsAPP() {
        $json = trim(file_get_contents('php://input')); 
        if (!empty($json)) {
            $inputData['ProductUrl'] = $this->input->post('ProductUrl', TRUE);
            $inputData['CityId'] = $this->input->post('CityId', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['ProductUrl'] && !empty($input_data)) {
                $inputData['ProductUrl'] = $input_data['ProductUrl'];
            }
            if (!$inputData['CityId'] && !empty($input_data)) {
                $inputData['CityId'] = $input_data['CityId'];
            }
            if($cityDetails = $this->Usermodel->getCityDetails($inputData['CityId'])){ 
                $deliveryDays = getDeliveryDays($cityDetails[0]['delivery_days']);
                $deliveryDaysNew = getDeliveryDaysForBoxApp($cityDetails[0]['delivery_days']);
                $deliveryDaysNewNEW = getDeliveryDaysForBox($cityDetails[0]['delivery_days']);
            }else{
                $deliveryDays = $deliveryDaysNew = 5;
            }
            if (($inputData['ProductUrl'])) {
                $res['productDetails'] = $this->Boxesmodel->getboxdetails($inputData['ProductUrl']);
                $productids = array();
                if ($res['productDetails']) {
                    foreach ($res['productDetails'] as $key => $values) {
                            $res['productDetails'][$key]['package_image'] = base_url().'upload/'.$values['package_image'];
                        if ($values['products_name']) {
                            $res['productDetails'][$key]['products_name_app'] = json_decode($values['products_name'], true);
                        } else {
                            $res['productDetails'][$key]['products_name_app'] = array();
                        }
                        $products = json_decode($values['products'], true);
                        if ($products) {
                            foreach ($products as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products[$keys]['productname'] = '';
                                    $products[$keys]['productimg'] = '';
                                }
                                $products[$keys]['productqty'] = $value['productqty'];
                                $products[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                                $products[$keys]['replacedproducts'] = json_decode($value['replacedproducts'], true);                      
                                
                            }
                        }
                        if (isset($res['productDetails'][$key]['products_name_app'][0])) {
                            $res['productDetails'][$key]['productlist'][0]['producttitle'] = $res['productDetails'][$key]['products_name_app'][0];
                        } else {
                            $res['productDetails'][$key]['productlist'][0]['producttitle'] = '';
                        }
                        $res['productDetails'][$key]['productlist'][0]['products'] = $products;
                        $res['productDetails'][$key]['productlist'][0]['delivery_dates'] = $deliveryDays;
                        $res['productDetails'][$key]['productlist'][0]['delivery_datesNew'] = $deliveryDaysNew;
                        $res['productDetails'][$key]['productlist'][0]['delivery_datesNewNEW'] = $deliveryDaysNewNEW;
                        $res['productDetails'][$key]['productlist'][0]['quanity'] = array(1,2,3,4,5);


                        $products2 = json_decode($values['products2'], true);
                        if ($products2) {
                            foreach ($products2 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products2[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products2[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products2[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products2[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products2[$keys]['productname'] = '';
                                    $products2[$keys]['productimg'] = '';
                                }
                                $products2[$keys]['productqty'] = $value['productqty'];
                                $products2[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                                $products2[$keys]['replacedproducts'] = json_decode($value['replacedproducts'], true);      
                            }
                        }
                        if (isset($res['productDetails'][$key]['products_name_app'][1])) {
                            $res['productDetails'][$key]['productlist'][1]['producttitle'] = $res['productDetails'][$key]['products_name_app'][1];
                        } else {
                            $res['productDetails'][$key]['productlist'][1]['producttitle'] = '';
                        }
                        $res['productDetails'][$key]['productlist'][1]['products'] = $products2;
                        $res['productDetails'][$key]['productlist'][1]['delivery_dates'] =$deliveryDays;
                        $res['productDetails'][$key]['productlist'][1]['delivery_datesNew'] =$deliveryDaysNew;
                        $res['productDetails'][$key]['productlist'][1]['delivery_datesNewNEW'] =$deliveryDaysNewNEW;
                        $res['productDetails'][$key]['productlist'][1]['quanity'] = array(1,2,3,4,5);
                        $products3 = json_decode($values['products3'], true);
                        if ($products3) {
                            foreach ($products3 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products3[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products3[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products3[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products3[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products3[$keys]['productname'] = '';
                                    $products3[$keys]['productimg'] = '';
                                }
                                $products3[$keys]['productqty'] = $value['productqty'];
                                $products3[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                                $products3[$keys]['replacedproducts'] = json_decode($value['replacedproducts'], true);    
                            }
                        }
                        if (isset($res['productDetails'][$key]['products_name_app'][2])) {
                            $res['productDetails'][$key]['productlist'][2]['producttitle'] = $res['productDetails'][$key]['products_name_app'][2];
                        } else {
                            $res['productDetails'][$key]['productlist'][2]['producttitle'] = '';
                        }
                        $res['productDetails'][$key]['productlist'][2]['products'] = $products3;
                        $res['productDetails'][$key]['productlist'][2]['delivery_dates'] = $deliveryDays;
                        $res['productDetails'][$key]['productlist'][2]['delivery_datesNew'] = $deliveryDaysNew;
                        $res['productDetails'][$key]['productlist'][2]['delivery_datesNewNEW'] = $deliveryDaysNewNEW;
                        $res['productDetails'][$key]['productlist'][2]['quanity'] = array(1,2,3,4,5);
                        $products4 = json_decode($values['products4'], true);
                        if ($products4) {
                            foreach ($products4 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products4[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products4[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products4[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products4[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products4[$keys]['productname'] = '';
                                    $products4[$keys]['productimg'] = '';
                                }
                                $products4[$keys]['productqty'] = $value['productqty'];
                                $products4[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                                $products4[$keys]['replacedproducts'] = json_decode($value['replacedproducts'], true);  
                            }
                        }
                        if (isset($res['productDetails'][$key]['products_name_app'][3])) {
                            $res['productDetails'][$key]['productlist'][3]['producttitle'] = $res['productDetails'][$key]['products_name_app'][3];
                        } else {
                            $res['productDetails'][$key]['productlist'][3]['producttitle'] = '';
                        }
                        $res['productDetails'][$key]['productlist'][3]['products'] = $products4;
                        $res['productDetails'][$key]['productlist'][3]['delivery_dates'] = $deliveryDays;
                        $res['productDetails'][$key]['productlist'][3]['delivery_datesNew'] = $deliveryDaysNew;
                        $res['productDetails'][$key]['productlist'][3]['delivery_datesNewNEW'] = $deliveryDaysNewNEW;
                        $res['productDetails'][$key]['productlist'][3]['quanity'] = array(1,2,3,4,5);
                        
                    }
                    $res['Buyget'] = 'Buy 3 get 4th scubscription box free';
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $res['productDetails'][0]['id_package']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                                //			$session[$key]['productjson'] = $list['productjson'];
                            }
                        }
                    } else {
                        $session = '';
                    }
                    $userData = $this->session->userdata('userid');
                    //	echo $userData; die;
                    if ($userData) {
                        $favData = $this->Productsmodel->addtofav($userData);
                        $usrdata['favProd'] = json_decode($favData[0]['fav_content'], true);
                        if ($usrdata['favProd']) {
                            if (in_array($res['productDetails'][0]['id_package'], $usrdata['favProd'])) {
                                $usrdata['is_fav'] = 'yes';
                            } else {
                                $usrdata['is_fav'] = 'no';
                            }
                        } else {
                            $usrdata['favProd'] = array();
                        }
                    } else {
                        $usrdata['favProd'] = array();
                    }
                    if ($productids) {
                        $res['recipes'] = $this->Productsmodel->recipesList($productids);
                    } else {
                        $res['recipes'] = array();
                    }
                } else {
                    
                }
                $boxsession = '';
                if ($boxinsession = $this->session->userdata('boxproductsreplace')) {
                    $boxsession = $boxinsession;
                }

                if ($res['productDetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Category wise product list.';
                    $result['Result'] = $res;
                    //	$result['recipes'] = array_unique($productids);
                    $result['Session'] = $session;
                    $result['usrdata'] = $usrdata;
                    $result['boxsession'] = $boxsession;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }
	public function boxcategoryList(){
		
		if($boxcategoryList = $this->Boxesmodel->boxcategoryList()){
			$result['Success'] = "TRUE";
			$result['Message'] = 'Box CategoryList List.';
			$result['Result'] = $boxcategoryList;
		}else{
			$result['Success'] = "FALSE";
			$result['Message'] = 'No CategoryList found.';
			$result['Result'] = array();
		}
		die(json_encode($result));
		
	}

}
