<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Gifthampers extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Gifthampersmodel');
        $this->load->model('Productsmodel');
        $this->load->library('session');
        $this->load->library('cart');
    }

    public function getboxes() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['id'] = $this->input->post('id', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['id'] && !empty($input_data)) {
                $inputData['id'] = $input_data['id'];
            }

            if (!empty($inputData['id'])) {
                $session = array();
                $res = $this->Gifthampersmodel->getboxes($status = 1);
                $sessionData = $this->cart->contents();
                foreach ($res as $key => $values) {
                    $res[$key]['package_price'] = ($values['package_price']);
                    $res[$key]['package_image_app'] = base_url() . 'upload/' . $values['package_image'];
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $id = str_ireplace("p", "", $list['id']);
                            if ($id == $values['id_package']) {
                                $session[$key]['id'] = $id;
                                $session[$key]['name'] = $list['name'];
                                $session[$key]['unitvalue'] = $list['unitvalue'];
                                $session[$key]['unitprice'] = $list['unitprice'];
                                $session[$key]['price'] = $list['price'];
                                $session[$key]['qty'] = $list['qty'];
                                $session[$key]['rowid'] = $list['rowid'];
                            }
                        }
                        $session = array_values($session);
                    } else {
                        $session = array();
                    }
                }
                $banner = array(
                    'banner' => base_url() . 'public/images/gifthamperbanner.jpg',
                    'title' => 'Gift Hampers',
                    'description' => "It's not how much we give but how much love we put in finding the perfect gift. We have created Healthy Gift Hampers so that you can gift something special to your friends and family.",
                );
                $result['Success'] = "TRUE";
                $result['Message'] = 'List Of Boxes';
                $result['Result'] = $res;
                $result['Banner'] = $banner;
                $result['Session'] = ($session);
                die(json_encode($result));
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    public function getboxdetails() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['ProductUrl'] = $this->input->post('ProductUrl', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['ProductUrl'] && !empty($input_data)) {
                $inputData['ProductUrl'] = $input_data['ProductUrl'];
            }

            if (($inputData['ProductUrl'])) {
                $res['productDetails'] = $this->Gifthampersmodel->getboxdetails($inputData['ProductUrl']);
                $productids = array();
                if ($res['productDetails']) {
                    foreach ($res['productDetails'] as $key => $values) {
                        $res['productDetails'][$key]['package_image_app'] = base_url().'upload/'.$values['package_image'];
                        $products = json_decode($values['products'], true);
                        if ($products) {
                            foreach ($products as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products[$keys]['productname'] = '';
                                    $products[$keys]['productimg'] = '';
                                }
                                $products[$keys]['productqty'] = $value['productqty'];
                                $products[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products'] = $products;
                        $products2 = json_decode($values['products2'], true);
                        if ($products2) {
                            foreach ($products2 as $keys => $value) {
                                $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                $products2[$keys]['productcategoryid'] = $value['productcategoryid'];
                                $products2[$keys]['productid'] = $value['productid'];
                                $productids[] = $value['productid'];
                                if ($pdetail) {
                                    $products2[$keys]['productname'] = $pdetail[0]['product_name'];
                                    $products2[$keys]['productimg'] = base_url() . 'upload/' . $pdetail[0]['product_actual_img'];
                                } else {

                                    $products2[$keys]['productname'] = '';
                                    $products2[$keys]['productimg'] = '';
                                }
                                $products2[$keys]['productqty'] = $value['productqty'];
                                $products2[$keys]['productquarter'] = json_decode($value['productquarter'], true);
                            }
                        }
                        $res['productDetails'][$key]['products2'] = $products2;
                    }
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $res['productDetails'][0]['id_package']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                                //			$session[$key]['productjson'] = $list['productjson'];
                            }
                        }
                    } else {
                        $session = '';
                    }
                    $userData = $this->session->userdata('userid');
                    //	echo $userData; die;
                    if ($userData) {
                        $favData = $this->Productsmodel->addtofav($userData);
                        $usrdata['favProd'] = json_decode($favData[0]['fav_content'], true);
                        if ($usrdata['favProd']) {
                            if (in_array($res['productDetails'][0]['id_package'], $usrdata['favProd'])) {
                                $usrdata['is_fav'] = 'yes';
                            } else {
                                $usrdata['is_fav'] = 'no';
                            }
                        } else {
                            $usrdata['favProd'] = '';
                        }
                    } else {
                        $usrdata['favProd'] = '';
                    }
                    $res['recipes'] = $this->Productsmodel->recipesList($productids);
                }
                $boxsession = '';
                if ($boxinsession = $this->session->userdata('boxproductsreplace')) {
                    $boxsession = $boxinsession;
                }

                if ($res['productDetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Category wise product list.';
                    $result['Result'] = $res;
                    //	$result['recipes'] = array_unique($productids);
                    $result['Session'] = $session;
                    $result['usrdata'] = $usrdata;
                    $result['boxsession'] = $boxsession;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

    /*
      function getalternateproducts(){
      $json = trim(file_get_contents('php://input'));
      if(!empty($json)){
      $inputData['productid'] =  $this->input->post('productid', TRUE);

      $input_data = json_decode($json, TRUE);

      if(!$inputData['productid'] && !empty($input_data)){
      $inputData['productid'] = $input_data['productid'];
      }

      if(!empty($inputData['productid'])){
      $res = $this->Productsmodel->productdetailsbyid($inputData['productid']);
      if($res){
      foreach($res as $key => $items){
      $products = $this->Productsmodel->productdetailsbyids(json_decode($items['alternate_prroducts'],true));
      }
      }else{
      $products = '';
      }
      $result['Success'] = "TRUE";
      $result['Message'] = 'List Of products';
      $result['Result'] =$products;
      die(json_encode($result));
      }else{
      $result['Success'] = "False";
      $result['Message'] = 'Parameters are incorrect';
      die(json_encode($result));
      }

      }else{
      $result['Success'] = "FALSE";
      $result['Message'] = 'Invalid resquest';
      die(json_encode($result));
      }
      } */

    function getalternateproducts() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['productid'] = $this->input->post('productid', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['productid'] && !empty($input_data)) {
                $inputData['productid'] = $input_data['productid'];
            }

            if (!empty($inputData['productid'])) {
                $inputData['productid'] = explode(',', $inputData['productid']);
                $inputData['productid'] = json_encode($inputData['productid']);
                $products = $this->Productsmodel->productdetailsbyids(json_decode($inputData['productid'], true));
                //	echo "<pre>"; print_r($products); die;

                if ($products) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'List Of products';
                    $result['Result'] = $products;
                    die(json_encode($result));
                } else {
                    $products = '';
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No product found yet!';
                    $result['Result'] = $products;
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

    function setreplacedproduct() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['img'] = $this->input->post('img', TRUE);
            $inputData['name'] = $this->input->post('name', TRUE);
            $inputData['oldproname'] = $this->input->post('oldproname', TRUE);
            $inputData['newproid'] = $this->input->post('newproid', TRUE);
            $inputData['oldproid'] = $this->input->post('oldproid', TRUE);
            $inputData['oldproqty'] = $this->input->post('oldproqty', TRUE);
            $inputData['boxid'] = $this->input->post('boxid', TRUE);
            $inputData['producttype'] = $this->input->post('producttype', TRUE);

            $input_data = json_decode($json, TRUE);

            if (!$inputData['name'] && !empty($input_data)) {
                $inputData['name'] = $input_data['name'];
            }

            if (!$inputData['img'] && !empty($input_data)) {
                $inputData['img'] = $input_data['img'];
            }
            if (!$inputData['oldproname'] && !empty($input_data)) {
                $inputData['oldproname'] = $input_data['oldproname'];
            }
            if (!$inputData['oldproqty'] && !empty($input_data)) {
                $inputData['oldproqty'] = $input_data['oldproqty'];
            }
            if (!$inputData['newproid'] && !empty($input_data)) {
                $inputData['newproid'] = $input_data['newproid'];
            }

            if (!$inputData['oldproid'] && !empty($input_data)) {
                $inputData['oldproid'] = $input_data['oldproid'];
            }

            if (!$inputData['boxid'] && !empty($input_data)) {
                $inputData['boxid'] = $input_data['boxid'];
            }

            if (!$inputData['producttype'] && !empty($input_data)) {
                $inputData['producttype'] = $input_data['producttype'];
            }

            if (!empty($inputData['img']) && !empty($inputData['name']) && !empty($inputData['oldproname']) && !empty($inputData['oldproqty']) && !empty($inputData['newproid']) && !empty($inputData['oldproid']) && !empty($inputData['boxid']) && !empty($inputData['producttype'])) {
                $res = $this->Gifthampersmodel->getboxdetailsById($inputData['boxid']);
                if ($res) {
                    $products['boxproductsreplace'][$inputData['boxid']] = array(
                        'boxid' => $inputData['boxid'],
                        'producttype' . $inputData['producttype'] => array(
                            'replacedproduct' => array(
                                'replacedproductid' => array(
                                    $inputData['oldproid'] => ($inputData['oldproid'])
                                ),
                                'replacedproductname' => array(
                                    $inputData['oldproid'] => ($inputData['oldproname'])
                                ),
                                'replacedproductqty' => array(
                                    $inputData['oldproid'] => ($inputData['oldproqty'])
                                ),
                            ),
                            'replaceproduct' => array(
                                'replaceproductid' => array(
                                    $inputData['oldproid'] => $inputData['newproid']
                                ),
                                'replaceproductname' => array(
                                    $inputData['oldproid'] => $inputData['name']
                                ),
                                'replaceproductqty' => array(
                                    $inputData['oldproid'] => $inputData['oldproqty']
                                ),
                                'replaceproductimg' => array(
                                    $inputData['oldproid'] => $inputData['img']
                                ),
                            ),
                        ),
                    );

                    $session = $products;
                    if ($s = $this->session->userdata('boxproductsreplace')) {

                        if ($s['boxproductsreplace'][$inputData['boxid']]) {
                            if (!isset($s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductid'][$inputData['oldproid']])) {


                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductid'][$inputData['oldproid']] = $inputData['oldproid'];
                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductname'][$inputData['oldproid']] = $inputData['oldproname'];
                                $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replacedproduct']['replacedproductqty'][$inputData['oldproid']] = $inputData['oldproqty'];
//$s['boxproductsreplace'][$inputData['boxid']]['producttype'.$inputData['producttype']]['replacedproduct']['replaceproductimg'][$inputData['oldproid']] = $inputData['img']; 
                                $this->session->set_userdata('boxproductsreplace', $s);
                            }
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductid'][$inputData['oldproid']] = $inputData['newproid'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductname'][$inputData['oldproid']] = $inputData['name'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductqty'][$inputData['oldproid']] = $inputData['oldproqty'];
                            $s['boxproductsreplace'][$inputData['boxid']]['producttype' . $inputData['producttype']]['replaceproduct']['replaceproductimg'][$inputData['oldproid']] = $inputData['img'];
                            $this->session->set_userdata('boxproductsreplace', $s);
                        }
                    } else {
                        $this->session->set_userdata('boxproductsreplace', $session);
                    }

                    $d = $this->session->userdata('boxproductsreplace');
                    //			echo "<pre>"; print_r($d); die;
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $inputData['boxid']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                                $products = json_decode($res[0]['products'], true);
                                if ($products) {
                                    foreach ($products as $keys => $value) {

                                        if (isset($d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']])) {

                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products[$keys]['productname'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductname'][$value['productid']];
                                            ;
                                            $products[$keys]['productid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductid'][$value['productid']];

                                            $products[$keys]['productqty'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replaceproduct']['replaceproductqty'][$value['productid']];
                                            $products[$keys]['oldproductid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype1']['replacedproduct']['replacedproductid'][$value['productid']];
                                        } else {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products[$keys]['productid'] = $value['productid'];
                                            $products[$keys]['productname'] = $pdetail[0]['product_name'];
                                            $products[$keys]['productqty'] = $value['productqty'];
                                            $products[$keys]['oldproductid'] = '';
                                        }
                                    }
                                }
                                $res['productDetails'][0]['products'] = $products;
                                $products2 = json_decode($res[0]['products2'], true);
                                if ($products2) {
                                    foreach ($products2 as $keys => $value) {
                                        if (isset($d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']])) {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products2[$keys]['productname'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductname'][$value['productid']];
                                            ;
                                            $products2[$keys]['productid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductid'][$value['productid']];

                                            $products2[$keys]['productqty'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replaceproduct']['replaceproductqty'][$value['productid']];
                                            $products2[$keys]['oldproductid'] = $d['boxproductsreplace'][$inputData['boxid']]['producttype2']['replacedproduct']['replacedproductid'][$value['productid']];
                                        } else {
                                            $pdetail = $this->Productsmodel->productdetailsbyid($value['productid']);
                                            $products2[$keys]['productid'] = $value['productid'];
                                            $products2[$keys]['productname'] = $pdetail[0]['product_name'];
                                            $products2[$keys]['productqty'] = $value['productqty'];
                                            $products2[$keys]['oldproductid'] = '';
                                        }
                                    }
                                }
                                $res['productDetails'][1]['products2'] = $products2;
                                $productJson = $res['productDetails'];
                                $session['productjson'] = $productJson;
                                $dataa = array(
                                    'rowid' => $list['rowid'],
                                    'productjson' => $session['productjson']
                                );
                                $this->cart->update($dataa);
                            }
                        }
                    } else {
                        $session = '';
                    }

                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Added successfully';
                    $result['Result'] = $d;
                    $result['Session'] = $session;
                    die(json_encode($result));
                } else {
                    $products = '';
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Invalid Box Id!';
                    $result['Result'] = $products;
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "False";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid resquest';
            die(json_encode($result));
        }
    }

}
