<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Products extends MX_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Productsmodel');
    }

    //list categories
    public function categorylist() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['CategoryID'] = $this->input->post('CategoryID', TRUE);
            $inputData['SubCategoryName'] = $this->input->post('SubCategoryName', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['CategoryID'] && !empty($input_data)) {
                $inputData['CategoryID'] = $input_data['CategoryID'];
            }

            if (!$inputData['SubCategoryName'] && !empty($input_data)) {
                $inputData['SubCategoryName'] = $input_data['SubCategoryName'];
            }

            if ($categoryList = $this->Productsmodel->categoryList($inputData['CategoryID'])) {
                foreach ($categoryList as $key => $value) {
                    $categoryList[$key]['cat_name_url'] = makeseofriendlyurl($value['cat_name']);
                }
                $result['Success'] = "TRUE";
                $result['Message'] = 'Category List.';
                $result['Result'] = $categoryList;
                if ($cat_name = $inputData['SubCategoryName']) {
                    $CategoryDetails = $this->Productsmodel->getcategoryById(null, $cat_name, $inputData['CategoryID']);
                } else {

                    $CategoryDetails = $this->Productsmodel->getcategoryById($inputData['CategoryID']);
                }
                $result['CategoryDetails'] = $CategoryDetails;
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'No category list found.';
                $result['Result'] = array();
                if ($cat_name = $inputData['SubCategoryName']) {
                    $CategoryDetails = $this->Productsmodel->getcategoryById(null, $cat_name);
                } else {

                    $CategoryDetails = $this->Productsmodel->getcategoryById($inputData['CategoryID']);
                }
                $result['CategoryDetails'] = $CategoryDetails;
            }
            die(json_encode($result));
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Incorrect Data input';
            $result['Result'] = array();
            die(json_encode($result));
        }
    }

    //Alllist categories
    public function categoryAlllist() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['CategoryID'] = $this->input->post('CategoryID', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['CategoryID'] && !empty($input_data)) {
                $inputData['CategoryID'] = $input_data['CategoryID'];
            }

            if ($categoryList = $this->Productsmodel->categoryAllList()) {
                foreach ($categoryList as $key => $list) {
                    $categoryList[$key]['subcategory'] = $this->Productsmodel->categoryList($list['catid']);
                }
                $result['Success'] = "TRUE";
                $result['Message'] = 'All Category  List.';
                $result['Result'] = $categoryList;
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'No category list found.';
                $result['Result'] = array();
            }
            die(json_encode($result));
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Incorrect Data input';
            $result['Result'] = array();
            die(json_encode($result));
        }
    }

    public function categorylistapp() {
        if ($categoryList = $this->Productsmodel->categoryList()) {
            $i = 0;
            foreach ($categoryList as $key => $value) {
                $final[$key]['id'] = $value['id'];
                $final[$key]['cat_name'] = ucfirst($value['cat_name']);
                $final[$key]['category_banner'] = base_url() . 'upload/category/' . $value['category_banner'];
                if ($value['category_icon']) {
                    $final[$key]['category_icon'] = base_url() . 'upload/category/' . $value['category_icon'];
                } else {
                    $final[$key]['category_icon'] = ''; //base_url().'upload/category/'.$value['category_icon'];
                }
                $final[$key]['sub_categories'] = $this->Productsmodel->categoryList($value['id']);
                if ($final[$key]['sub_categories']) {
                    foreach ($final[$key]['sub_categories'] as $skey => $slist) {
                        $final[$key]['sub_categories'][$skey]['category_banner'] = base_url() . 'upload/category/' . $slist['category_banner'];
                        if ($slist['category_icon']) {
                            $final[$key]['sub_categories'][$skey]['category_icon'] = base_url() . 'upload/category/' . $slist['category_icon'];
                        } else {
                            $final[$key]['sub_categories'][$skey]['category_icon'] = ''; //base_url().'upload/category/'.$slist['category_icon'];						
                        }
                    }
                }
            }
            $result['Success'] = "TRUE";
            $result['Message'] = 'Category list with sub categories.';
            $result['Result'] = $final;
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'No category list found.';
            $result['Result'] = array();
        }
        die(json_encode($result));
    }

    public function getRecipes() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['filter'] = $this->input->post('filter', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['filter'] && !empty($input_data)) {
                $inputData['filter'] = $input_data['filter'];
            }
        }
        if ($getRecipes = $this->Productsmodel->getRecipes($status = '1', $inputData['filter'])) {
            foreach ($getRecipes as $key => $list) {
                $getRecipes[$key] = $list;
                $getRecipes[$key]['recipe_ingredients_products_id_APP'] = json_decode($list['recipe_ingredients_products_id'], true);

                $getRecipes[$key]['recipe_imgAPP'] = base_url() . 'upload/' . $list['recipe_img'];
            }
            $result['Success'] = "TRUE";
            $result['Message'] = 'Recipe list with sub categories.';
            $result['Result'] = $getRecipes;
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'No recipes found.';
            $result['Result'] = array();
        }
        die(json_encode($result));
    }

    public function getRecipesCusine() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['filter'] = $this->input->post('filter', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['filter'] && !empty($input_data)) {
                $inputData['filter'] = $input_data['filter'];
            }
        }
        if ($getRecipes = $this->Productsmodel->getRecipesCusine($status = '1', $inputData['filter'])) {

            $result['Success'] = "TRUE";
            $result['Message'] = 'Recipe list with sub categories.';
            $result['Result'] = $getRecipes;
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'No recipes found.';
            $result['Result'] = array();
        }
        die(json_encode($result));
    }

    //list products
    public function productlist() {
        $json = trim(file_get_contents('php://input'));
        //	echo "<pre>"; print_r($json); die;
        if (!empty($json)) {
            $inputData['CategoryID'] = $this->input->post('CategoryID', TRUE);
            $inputData['patCategoryID'] = $this->input->post('patCategoryID', TRUE);
            $inputData['is_new'] = $this->input->post('is_new', TRUE);
            $inputData['userId'] = $this->input->post('userId', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['CategoryID'] && !empty($input_data)) {
                $inputData['CategoryID'] = $input_data['CategoryID'];
            }
            if (!$inputData['patCategoryID'] && !empty($input_data)) {
                $inputData['patCategoryID'] = $input_data['patCategoryID'];
            }
            if (!$inputData['is_new'] && !empty($input_data)) {
                $inputData['is_new'] = $input_data['is_new'];
            }

            if (!$inputData['userId'] && !empty($input_data)) {
                $inputData['userId'] = $input_data['userId'];
            }
            //	echo "<pre>"; print_r($inputData); die;
            if (($inputData['CategoryID']) || $inputData['patCategoryID']) {
                if($inputData['is_new']){                    
                    $res['productList'] = $this->Productsmodel->productlistisNew($inputData);
                }else{
                    $res['productList'] = $this->Productsmodel->productlist($inputData);
                }
                $session = array();
                $i = 0;
                $sessionData = $this->cart->contents();
                if (!empty($inputData['userId'])) {
                    $userData = $inputData['userId'];
                } else {
                    $userData = ($this->session->userdata('userid'));
                }
                //		echo $userData; die;
                if ($userData) {
                    $favData = $this->Productsmodel->addtofav($userData);
                    //	echo "<pre>"; print_r($favData ); die;
                    if ($favData) {
                        $usrdata['favProd'] = array_values(json_decode($favData[0]['fav_content'], true));
                        $usrdata['favProdAPP'] = array_values(json_decode($favData[0]['fav_content'], true));
                    } else {
                        $usrdata['favProd'] = '';
                        $usrdata['favProdAPP'] = array();
                    }
                } else {
                    $usrdata['favProd'] = '';
                    $usrdata['favProdAPP'] = array();
                }

                if ($res['productList']) {
                    foreach ($res['productList'] as $key => $values) {
                        $res['productList'][$key]['product_actual_img'] = base_url() . 'upload/' . $values['product_actual_img'];
                        if (($res['productList'][$key]['product_selected_weight_unit'])) {
                            $res['productList'][$key]['product_selected_weight_unit'] = json_decode($values['product_selected_weight_unit'], true);
                            if (!empty($values['product_selected_weight_unit']) && ($values['product_selected_weight_unit']) != '""') {
                                $res['productList'][$key]['product_selected_weight_unit_app'] = array_values(json_decode($values['product_selected_weight_unit'], true));
                            } else {
                                $res['productList'][$key]['product_selected_weight_unit_app'] = array();
                            }
                        } else {
                            $res['productList'][$key]['product_selected_weight_unit'] = '';
                            $res['productList'][$key]['product_selected_weight_unit_app'] = array();
                        }
                        $productAttachments = $this->Productsmodel->productAttachments($values['pid']);
                        if ($productAttachments) {
                            foreach ($productAttachments as $AD) {
                                $Pl[] = $AD['product_attachment'];
                            }
                            $res['productList'][$key]['productAttachments'] = $Pl;
                        } else {
                            $res['productList'][$key]['productAttachments'] = array();
                        }

                        if ($sessionData) {
                            foreach ($sessionData as $list) {
                                $id = str_ireplace("p", "", $list['id']);
                                if ($id == $values['pid']) {
                                    $session[$key]['id'] = $id;
                                    $session[$key]['name'] = $list['name'];
                                    $session[$key]['unitvalue'] = $list['unitvalue'];
                                    $session[$key]['unitprice'] = $list['unitprice'];
                                    $session[$key]['price'] = $list['price'];
                                    $session[$key]['qty'] = $list['qty'];
                                    $session[$key]['rowid'] = $list['rowid'];
                                }
                                $i++;
                            }
                        } else {
                            $session = array();
                        }
                    }
                }
                $units = units();
                $units['weight'] = array_values($units['weight']);
                $units['piece'] = array_values($units['piece']);
                $units['drink'] = array_values($units['drink']);
                //	echo "<pre>"; print_r($session); die;
                if ($res['productList']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Category wise product list.';
                    $result['Result'] = $res;
                    $result['Result']['units'] = $units;
                    $result['Session'] = array_values($session);
                    $result['usrdata'] = ($usrdata);
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

    //list of all products
    public function allproductlist() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['all'] = $this->input->post('all', TRUE);
            $input_data = json_decode($json, TRUE);

            if (!$inputData['all'] && !empty($input_data)) {
                $inputData['all'] = $input_data['all'];
            }
            if (($inputData['all'])) {
                $res['productList'] = '';
                $product = $this->Productsmodel->allproductlist2($inputData);
                $session = array();
                $i = 0;
                $sessionData = $this->cart->contents();
                $userData = ($this->session->userdata('userid'));
                if ($userData) {
                    $favData = $this->Productsmodel->addtofav($userData);
                    if ($favData) {
                        $usrdata['favProd'] = array_values(json_decode($favData[0]['fav_content'], true));
                    } else {
                        $usrdata['favProd'] = '';
                    }
                } else {
                    $usrdata['favProd'] = '';
                }
                if ($product) {
                    if ($productlist = $this->Productsmodel->getProductListWhereIn(json_decode($product[0]['alternate_prroducts'], true))) {
                        $res['productList'] = $productlist;
                    } else {
                        $productlist = $this->Productsmodel->allTopProductlist();
                        $res['productList'] = $productlist;
                    }
                    if ($res['productList']) {
                        //	echo"<pre>"; print_r($res); die;
                        foreach ($res['productList'] as $key => $values) {
                            if ($res['productList'][$key]['product_selected_weight_unit']) {
                                $res['productList'][$key]['product_selected_weight_unit'] = json_decode($values['product_selected_weight_unit'], true);
                            } else {
                                $res['productList'][$key]['product_selected_weight_unit'] = '';
                            }
                            $productAttachments = $this->Productsmodel->productAttachments($values['pid']);
                            if ($productAttachments) {
                                foreach ($productAttachments as $AD) {
                                    $Pl[] = $AD['product_attachment'];
                                }
                                $res['productList'][$key]['productAttachments'] = $Pl;
                            } else {
                                $res['productList'][$key]['productAttachments'] = array();
                            }

                            if ($sessionData) {
                                foreach ($sessionData as $list) {
                                    $id = str_ireplace("p", "", $list['id']);
                                    if ($id == $values['pid']) {
                                        $session[$key]['id'] = $id;
                                        $session[$key]['name'] = $list['name'];
                                        $session[$key]['price'] = $list['price'];
                                        $session[$key]['unitvalue'] = $list['unitvalue'];
                                        $session[$key]['unitprice'] = $list['unitprice'];
                                        $session[$key]['qty'] = $list['qty'];
                                        $session[$key]['rowid'] = $list['rowid'];
                                    }
                                    $i++;
                                }
                            } else {
                                $session = array();
                            }
                        }
                    }
                }


                if ($res['productList']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'List of all products.';
                    $result['Result'] = $res;
                    $result['Session'] = array_values($session);
                    $result['usrdata'] = ($usrdata);
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

    //list products
    public function productDetails() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['ProductUrl'] = $this->input->post('ProductUrl', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['ProductUrl'] && !empty($input_data)) {
                $inputData['ProductUrl'] = $input_data['ProductUrl'];
            }

            if (($inputData['ProductUrl'])) {
                $res['productDetails'] = $this->Productsmodel->productdetails($inputData);
                if ($res['productDetails']) {
                    foreach ($res['productDetails'] as $key => $values) {
                        if ($res['productDetails'][$key]['product_selected_weight_unit']) {
                            $res['productDetails'][$key]['product_selected_weight_unit'] = json_decode($values['product_selected_weight_unit'], true);
                        } else {
                            $res['productDetails'][$key]['product_selected_weight_unit'] = '';
                        }
                        $productAttachments = $this->Productsmodel->productAttachments($values['pid']);
                        if ($productAttachments) {
                            foreach ($productAttachments as $AD) {
                                $Pl[] = $AD['product_attachment'];
                            }
                            $res['productDetails'][$key]['productAttachments'] = $Pl;
                        } else {
                            $res['productDetails'][$key]['productAttachments'] = array();
                        }
                    }
                    $session = '';
                    $sessionData = $this->cart->contents();
                    if ($sessionData) {
                        foreach ($sessionData as $list) {
                            $list['id'] = str_ireplace("p", "", $list['id']);
                            if ($list['id'] == $res['productDetails'][0]['pid']) {
                                $session['id'] = $list['id'];
                                $session['name'] = $list['name'];
                                $session['unitprice'] = $list['unitprice'];
                                $session['unitvalue'] = $list['unitvalue'];
                                $session['price'] = $list['price'];
                                $session['qty'] = $list['qty'];
                                $session['rowid'] = $list['rowid'];
                            }
                        }
                    } else {
                        $session = '';
                    }
                    $userData = $this->session->userdata('userid');
                    //	echo $userData; die;
                    if ($userData) {
                        $favData = $this->Productsmodel->addtofav($userData);
                        $usrdata['favProd'] = json_decode($favData[0]['fav_content'], true);
                        if ($usrdata['favProd']) {
                            if (in_array($res['productDetails'][0]['pid'], $usrdata['favProd'])) {
                                $usrdata['is_fav'] = 'yes';
                            } else {
                                $usrdata['is_fav'] = 'no';
                            }
                        } else {
                            $usrdata['favProd'] = '';
                        }
                    } else {
                        $usrdata['favProd'] = '';
                    }
                    $res['recipes'] = $this->Productsmodel->recipesList($res['productDetails'][0]['pid']);
                }


                if ($res['productDetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Category wise product list.';
                    $result['Result'] = $res;
                    $result['Session'] = $session;
                    $result['usrdata'] = $usrdata;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

    //list products
    public function recipiedetails() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['recipe_url'] = $this->input->post('recipe_url', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['recipe_url'] && !empty($input_data)) {
                $inputData['recipe_url'] = $input_data['recipe_url'];
            }

            if (($inputData['recipe_url'])) {
                $session = '';
                $sessionData = $this->cart->contents();
                $sessionData2 = array_values($sessionData);
                $recipe_ingredients_in_cart = false;
                $recipe = array();
                $t = '';
                $res['recipedetails'] = $this->Productsmodel->recipiedetails($inputData['recipe_url']);
                if ($res['recipedetails']) {
                    $recipe_ingredients = json_decode($res['recipedetails'][0]['recipe_ingredients_products_id'], true);
                    if ($recipe_ingredients) {
                        foreach ($recipe_ingredients as $key => $values) {
                            $t .= $values['productid'] . ',';
                            $recipe[$key] = $this->Productsmodel->productdetailsbyid($values['productid'])[0];
                            $recipe[$key]['inputQty'] = ($values['productqty']);
                            $k = array_search('p' . $values['productid'], array_column($sessionData2, 'id'));
                            if (is_int($k)) {
                                if (isset($sessionData2[$k]['rowid'])) {
                                    $recipe_ingredients_in_cart = true;
                                }
                            }
                        }
                    }

                    /* foreach($res['recipe_url'] as $key =>$values){
                      $productAttachments = $this->Productsmodel->productAttachments($values['pid']);
                      if($productAttachments){
                      foreach($productAttachments as $AD){
                      $Pl[] = $AD['recipe_url'];
                      }
                      $res['recipe_url'][$key]['productAttachments'] = $Pl;
                      }else{
                      $res['recipe_url'][$key]['productAttachments'] = array();
                      }
                      } */

                    $res['recipedetails'][0]['ingredients_products'] = $recipe;
                    $res['recipedetails'][0]['recipe_ingredients_products_id'] = array_filter(explode(',', $t));

                    foreach ($res['recipedetails'][0]['ingredients_products'] as $key => $values) {
                        if ($values['product_selected_weight_unit']) {
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unit'] = json_decode($values['product_selected_weight_unit'], true);
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unitAPP'] = array_values(json_decode($values['product_selected_weight_unit'], true));
                        } else {
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unit'] = '';
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unitAPP'] = array();
                        }
                    }
                }

                if ($res['recipedetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Recipe details.';
                    $result['Result'] = $res;
                    $result['Cart'] = $sessionData;
                    $result['recipe_ingredients_in_cart'] = $recipe_ingredients_in_cart;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

    //about us
    //term and conditions
    //join as former
    //city list
    public function citylist() {

        if ($citylist = $this->Productsmodel->citylist()) {
            $result['Success'] = "TRUE";
            $result['Message'] = 'City List.';
            $result['Result'] = $citylist;
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'No City found.';
            $result['Result'] = array();
        }
        die(json_encode($result));
    }

    public function searchproducts() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['term'] = $this->input->post('term', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['term'] && !empty($input_data)) {
                $inputData['term'] = $input_data['term'];
            }

            if ($inputData['term']) {
                $res = $this->Productsmodel->searchproducts($inputData['term']);
                if ($res) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = "Product list by search!";
                    $result['Result'] = $res;
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = "Invalid Request";
                    $result['Result'] = array();
                    die(json_encode($result));
                }
                die(json_encode($result));
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = "Invalid Request";
                $result['Result'] = array();
                die(json_encode($result));
            }
        }
    }

    public function recipedetailsAPP() {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['recipe_url'] = $this->input->post('recipe_url', TRUE);
            $inputData['userId'] = $this->input->post('userId', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['recipe_url'] && !empty($input_data)) {
                $inputData['recipe_url'] = $input_data['recipe_url'];
            }
            if (!$inputData['userId'] && !empty($input_data)) {
                $inputData['userId'] = $input_data['userId'];
            }

            if (($inputData['recipe_url'])) {
                $session = '';
                $sessionData = $this->cart->contents();
                $sessionData2 = array_values($sessionData);
                $recipe_ingredients_in_cart = false;
                $recipe = array();
                $t = '';
                $res['recipedetails'] = $this->Productsmodel->recipiedetails($inputData['recipe_url']);
                if ($res['recipedetails']) {
                $res['recipedetails'][0]['recipe_img_app'] = base_url() . 'upload/' . $res['recipedetails'][0]['recipe_img'];
                    $recipe_ingredients = json_decode($res['recipedetails'][0]['recipe_ingredients_products_id'], true);
                    if ($recipe_ingredients) {
                        foreach ($recipe_ingredients as $key => $values) {
                            $t .= $values['productid'] . ',';
                            $recipe[$key] = $this->Productsmodel->productdetailsbyid($values['productid'])[0];
                            $recipe[$key]['inputQty'] = ($values['productqty']);
                            $recipe[$key]['product_actual_img_app'] = base_url() . 'upload/' . $recipe[$key]['product_actual_img'];
                            $k = array_search('p' . $values['productid'], array_column($sessionData2, 'id'));
                            if (is_int($k)) {
                                if (isset($sessionData2[$k]['rowid'])) {
                                    $recipe_ingredients_in_cart = true;
                                }
                            }
                        }
                    }



                    $res['recipedetails'][0]['ingredients_products'] = array_values($recipe);
                    $res['recipedetails'][0]['recipe_ingredients_products_id'] = array_filter(explode(',', $t));

                    foreach ($res['recipedetails'][0]['ingredients_products'] as $key => $Ivalues) {
                        if ($Ivalues['product_selected_weight_unit']) {
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unit'] = json_decode($Ivalues['product_selected_weight_unit'], true);
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unitAPP'] = array_values(json_decode($Ivalues['product_selected_weight_unit'], true));
                          //  $res['recipedetails'][0]['ingredients_products'] = array_values($res['recipedetails'][0]['ingredients_products']);
                        } else {
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unit'] = '';
                            $res['recipedetails'][0]['ingredients_products'][$key]['product_selected_weight_unitAPP'] = array();
                        }
                    }
                }
                $units = units();
                $units['weight'] = array_values($units['weight']);
                $units['piece'] = array_values($units['piece']);
                $units['drink'] = array_values($units['drink']);
                if (!empty($inputData['userId'])) {
                    $userData = $inputData['userId'];
                    $favData = $this->Productsmodel->addtofav($userData);
                    if ($favData) {
                        $usrdata['favProd'] = array_values(json_decode($favData[0]['fav_content'], true));
                        $usrdata['favProdAPP'] = array_values(json_decode($favData[0]['fav_content'], true));
                    } else {
                        $usrdata['favProd'] = '';
                        $usrdata['favProdAPP'] = array();
                    }
                } else {
                    $usrdata['favProd'] = '';
                    $usrdata['favProdAPP'] = array();
                }
                if ($res['recipedetails']) {
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Recipe details.';
                    $result['Result'] = $res;
                    $result['Cart'] = $sessionData;
                    $result['usrdata'] = ($usrdata);
                    $result['Result']['units'] = $units;
                    $result['recipe_ingredients_in_cart'] = $recipe_ingredients_in_cart;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'No products found.';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Parameters are incorrect';
                die(json_encode($result));
            }
        }
    }

}
