<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Signup extends MX_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Signupmodel');
    }

    public function userRegistration()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['FName'] = $this->input->post('FName', TRUE);
            $inputData['LName'] = $this->input->post('LName', TRUE);
            $inputData['Email'] = $this->input->post('Email', TRUE);
            $inputData['Mobile'] = $this->input->post('Mobile', TRUE);
            $inputData['Password'] = $this->input->post('Password', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!($inputData['FName']) && isset($input_data['FName'])) {
                $inputData['FName'] = $input_data['FName'];
            }
            if (!($inputData['LName']) && isset($input_data['LName'])) {
                $inputData['LName'] = $input_data['LName'];
            }
            if (!($inputData['Email']) && isset($input_data['Email'])) {
                $inputData['Email'] = $input_data['Email'];
            }
            if (!($inputData['Mobile']) && isset($input_data['Mobile'])) {
                $inputData['Mobile'] = $input_data['Mobile'];
            }
            if (!($inputData['Password']) && isset($input_data['Password'])) {
                $inputData['Password'] = $input_data['Password'];
            }
            if (!empty($inputData['FName']) && !empty($inputData['LName']) && !empty($inputData['Email']) && !empty($inputData['Mobile']) && !empty($inputData['Password'])) {
                $inputData['OTP'] = rand(100000, 999999);
                $inputData['OTP'] = 123456;
                if (!$checkMobileExist = $this->Signupmodel->checkMobileExist($inputData)) {
                    $userRegistration = $this->Signupmodel->userRegistration($inputData);
                    if ($userRegistration) {
                        $result['Success'] = "TRUE";
                        $result['Message'] = 'Account created successfully!';
                        $result['OTP'] = $inputData['OTP'];
                        $result['UserId'] = $userRegistration;
                        $mobileNo = $inputData['Mobile'];
                        $msg = 'Hi your Login OTP : ' . $inputData['OTP'];
                        $smsText = str_replace(" ", "%20", $msg);
                        sendSMS($mobileNo, $smsText);
                        die(json_encode($result));
                    } else {
                        $result['Success'] = "FALSE";
                        $result['Message'] = 'Invalid request parameters!';
                        $result['Result'] = array();
                        die(json_encode($result));
                    }
                } else {
                    if ($checkMobileExist->status == 0) { 
                        $arr = [
                            'otp' => $inputData['OTP']
                        ];
                        $this->Signupmodel->UpdateDoctor($arr, $checkMobileExist->doctor_id);
                        $result['Success'] = "TRUE";
                        $result['Message'] = 'Account created successfully!';
                        $result['OTP'] = $inputData['OTP'];
                        $result['UserId'] = $checkMobileExist->doctor_id;
                        $mobileNo = $inputData['Mobile'];
                        $msg = 'Hi your Login OTP : ' . $inputData['OTP'];
                        $smsText = str_replace(" ", "%20", $msg);
                        sendSMS($mobileNo, $smsText);
                        die(json_encode($result));
                    } else {
                        $result['Success'] = "FALSE";
                        $result['Message'] = 'Account already exist, go to login!';
                        $result['Result'] = array();
                        die(json_encode($result));
                    }
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Required parameters is missing!';
                $result['Result'] = array();
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid request!';
            $result['Result'] = array();
            die(json_encode($result));
        }
    }

    public function VerifyOTP()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $inputData['OTP'] = $this->input->post('OTP', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }
            if (!$inputData['OTP'] && isset($input_data['OTP'])) {
                $inputData['OTP'] = $input_data['OTP'];
            }
            //echo "<pre>";print_r($inputData); die;
            if (!empty($inputData['UserId']) && !empty($inputData['OTP'])) {
                if ($userRegistration = $this->Signupmodel->VerifyOTP($inputData)) {
                    $data['Details']['UserId'] = $userRegistration->doctor_id;
                    $data['Details']['Name'] = $userRegistration->doctor_fname . ' ' . $userRegistration->doctor_lname;
                    $data['Details']['Email'] = $userRegistration->doctor_email;
                    $data['Details']['Mobile'] = $userRegistration->doctor_mobile;
                    $data['Details']['Password'] = $userRegistration->doctor_password;

                    $arr = [
                        'status' => 1
                    ];
                    $this->Signupmodel->UpdateDoctor($arr, $userRegistration->doctor_id);
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'OTP verified successfully!';
                    $result['Result'] = $data;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Failed to verify otp try again!';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Required parameters is missing!';
                $result['Result'] = array();
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid request!';
            $result['Result'] = array();
            die(json_encode($result));
        }
    }

    public function Login()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['Mobile'] = $this->input->post('Mobile', TRUE);
            $inputData['Password'] = $this->input->post('Password', TRUE);
            $inputData['AppVersion'] = $this->input->post('AppVersion', TRUE);
            $inputData['AndroidVersion'] = $this->input->post('AndroidVersion', TRUE);
            $inputData['DeviceName'] = $this->input->post('DeviceName', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['Mobile'] && !empty($input_data)) {
                $inputData['Mobile'] = $input_data['Mobile'];
            }
            if (!$inputData['Password'] && !empty($input_data)) {
                $inputData['Password'] = $input_data['Password'];
            }
            if (!$inputData['AppVersion'] && !empty($input_data)) {
                $inputData['AppVersion'] = $input_data['AppVersion'];
            }
            if (!$inputData['AndroidVersion'] && !empty($input_data)) {
                $inputData['AndroidVersion'] = $input_data['AndroidVersion'];
            }
            if (!$inputData['DeviceName'] && !empty($input_data)) {
                $inputData['DeviceName'] = $input_data['DeviceName'];
            }
            if ($inputData['Mobile'] && $inputData['Password']) {
                if ($userRegistration = $this->Signupmodel->Login($inputData)) {
                    //echo '<pre>'; print_r($userRegistration); die;
                    $data['Details']['UserId'] = $userRegistration->doctor_id;
                    $data['Details']['Name'] = $userRegistration->doctor_fname . ' ' . $userRegistration->doctor_lname;
                    $data['Details']['Email'] = $userRegistration->doctor_email;
                    $data['Details']['Mobile'] = $userRegistration->doctor_mobile;
                    $data['Details']['Password'] = $userRegistration->doctor_password;
                    $data['Details']['ProfilePic'] = $userRegistration->profile_image;
                    $data['Details']['State'] = $userRegistration->state_name;
                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Account Login';
                    $result['Result'] = $data;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = 'Invalid mobile number or password!';
                    $result['Result'] = array();
                    die(json_encode($result));
                }
            } else {
                $result['Success'] = "FALSE";
                $result['Message'] = 'Required parameters is missing!';
                $result['Result'] = array();
                die(json_encode($result));
            }
        } else {
            $result['Success'] = "FALSE";
            $result['Message'] = 'Invalid request!';
            $result['Result'] = array();
            die(json_encode($result));
        }
    }

    public function UpdateProfile()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $inputData['FName'] = $this->input->post('FName', TRUE);
            $inputData['LName'] = $this->input->post('LName', TRUE);
            $inputData['Email'] = $this->input->post('Email', TRUE);
            $inputData['ProfilePic'] = $this->input->post('ProfilePic', TRUE);
            $inputData['State'] = $this->input->post('State', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }
            if (!$inputData['FName'] && isset($input_data['FName'])) {
                $inputData['FName'] = $input_data['FName'];
            }
            if (!$inputData['LName'] && isset($input_data['LName'])) {
                $inputData['LName'] = $input_data['LName'];
            }
            if (!$inputData['Email'] && isset($input_data['Email'])) {
                $inputData['Email'] = $input_data['Email'];
            }
            if (!$inputData['ProfilePic'] && isset($input_data['ProfilePic'])) {
                $inputData['ProfilePic'] = $input_data['ProfilePic'];
            }
            if (!$inputData['State'] && isset($input_data['State'])) {
                $inputData['State'] = $input_data['State'];
            }

            if (!empty($inputData['UserId'])) {
                if ($inputData['ProfilePic']) {
                    $finalImage = base64_decode($inputData['ProfilePic']);
                    $uploadFolder = "upload/profilepic/";
                    if (!is_dir($uploadFolder)) {
                        mkdir($uploadFolder);
                        chmod($uploadFolder, 777);
                    }
                    $finalImageName = $inputData['FName'] . "_profile_pic_" . time() . ".png";
                    file_put_contents($uploadFolder . "/" . $finalImageName, $finalImage);

                    $imgData['ProfilePic'] = base_url() . 'upload/profilepic/' . $finalImageName;

                    $inputData['ProfilePic'] = $imgData['ProfilePic'];
                } else {
                    $inputData['ProfilePic'] = '';
                }

                $updatePatient = $this->Signupmodel->UpdateProfile($inputData);
                if ($userDetails = $this->Signupmodel->userDetailsById($inputData)) {
                    $data['Details']['UserId'] = $userDetails->doctor_id;
                    $data['Details']['Name'] = $userDetails->doctor_fname . ' ' . $userDetails->doctor_lname;
                    $data['Details']['Email'] = $userDetails->doctor_email;
                    $data['Details']['Mobile'] = $userDetails->doctor_mobile;
                    $data['Details']['Password'] = $userDetails->doctor_password;
                    $data['Details']['ProfilePic'] = $userDetails->profile_image;
                    $data['Details']['State'] = $userDetails->state_name;

                    $result['Success'] = "True";
                    $result['Message'] = "Update Successfully!";
                    $result['Result'] = $data;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = "Record not found try again!";
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function ForgotPassword()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['Mobile'] = $this->input->post('MobileNo', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['Mobile'] && isset($input_data['MobileNo'])) {
                $inputData['Mobile'] = $input_data['MobileNo'];
            }

            if (!empty($inputData['Mobile'])) {
                if ($checkMobileExist = $this->Signupmodel->checkMobileExist($inputData)) {
                    $inputData['Otp'] = rand(100000, 999999);
                    $inputData['Otp'] = 123456;
                    $arr = array(
                        'otp' => $inputData['Otp'],
                    );
                    $this->Signupmodel->UpdateDoctor($arr, $checkMobileExist->doctor_id);
                    $result['Success'] = "True";
                    $result['Message'] = "Otp sent successfully!";
                    $result['Result'] = $checkMobileExist;

                    $mobileNo = $inputData['Mobile'];
                    $msg = 'Hi your forgot password OTP : ' . $inputData['Otp'];
                    $smsText = str_replace(" ", "%20", $msg);
                    sendSMS($mobileNo, $smsText);
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = "Record not found try again!";
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function ResetPassword()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['Mobile'] = $this->input->post('MobileNo', TRUE);
            $inputData['Password'] = $this->input->post('Password', TRUE);

            $input_data = json_decode($json, TRUE);
            if (!$inputData['Mobile'] && isset($input_data['MobileNo'])) {
                $inputData['Mobile'] = $input_data['MobileNo'];
            }
            if (!$inputData['Password'] && isset($input_data['Password'])) {
                $inputData['Password'] = $input_data['Password'];
            }

            if (!empty($inputData['Mobile'] && !empty($inputData['Password']))) {
                if ($checkMobileExist = $this->Signupmodel->checkMobileExist($inputData)) {
                    $arr = array(
                        'doctor_password' => md5($inputData['Password']),
                    );
                    $this->Signupmodel->UpdateDoctor($arr, $checkMobileExist->doctor_id);
                    $result['Success'] = "True";
                    $result['Message'] = "Your password updated successfully!";
                    $result['Result'] = $checkMobileExist;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "FALSE";
                    $result['Message'] = "Record not found try again!";
                    die(json_encode($result));
                }
            } else {
                echo json_encode(array('Success' => "FALSE", 'Message' => 'wrong key', 'Result' => array()));
                exit;
            }
        } else {
            echo json_encode(array('Success' => "FALSE", 'Message' => 'Incorrect parameters', 'Result' => array()));
            exit;
        }
    }

    public function Help()
    {
        $json = trim(file_get_contents('php://input'));
        if (!empty($json)) {
            $inputData['UserId'] = $this->input->post('UserId', TRUE);
            $inputData['Question'] = $this->input->post('Question', TRUE);
            $inputData['Rating'] = $this->input->post('Rating', TRUE);
            $inputData['Comment'] = $this->input->post('Comment', TRUE);
            $input_data = json_decode($json, TRUE);
            if (!$inputData['UserId'] && isset($input_data['UserId'])) {
                $inputData['UserId'] = $input_data['UserId'];
            }
            if (!$inputData['Question'] && isset($input_data['Question'])) {
                $inputData['Question'] = $input_data['Question'];
            }
            if (!$inputData['Rating'] && isset($input_data['Rating'])) {
                $inputData['Rating'] = $input_data['Rating'];
            }
            if (!$inputData['Comment'] && isset($input_data['Comment'])) {
                $inputData['Comment'] = $input_data['Comment'];
            }

            // print_r($inputData);die;
            if (!empty($inputData['UserId'])) {
                $userTable = [
                    'doctor_id' => $inputData['UserId'],
                    'doc_question' => $inputData['Question'],
                    'doc_rating' => $inputData['Rating'],
                    'doc_comment' => $inputData['Comment'],
                ];
                $res = $this->Signupmodel->submitDoctorHelp($userTable);
                if ($res) {

                    $result['Success'] = "TRUE";
                    $result['Message'] = 'Submitted successfully.';
                    $result['Result'] = $res;
                    die(json_encode($result));
                } else {
                    $result['Success'] = "False";
                    $result['Message'] = 'Failed to submit try again!';
                    die(json_encode($result));
                }
            } else {

                $result['Success'] = "False";
                $result['Message'] = 'Invalid given request!';
                die(json_encode($result));
            }
        } else {

            $result['Success'] = "False";
            $result['Message'] = 'Invalid request!';
            die(json_encode($result));
        }
    }
}
