<?php

class Ordermodel extends CI_Model {

    public function __construct() {

        parent::__construct();
    }

    public function checkSessionIdInCart($data) {
        $this->db->select('*');
        $this->db->from('cart');
        $this->db->where('session_id', $data['sessionid']);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function addtocart($cartData) {
        $this->db->insert('cart', $cartData);
        return $this->db->insert_id();
    }

    public function insertPaymentLeaser($data) {
        $this->db->insert('payment_leaser', $data);
        return $this->db->insert_id();
    }

    public function addorder($orderData) {
        date_default_timezone_set('Asia/Kolkata');
        $orderData['order_date_time'] = date('Y-m-d H:i:s');
        $this->db->insert('orders', $orderData);
        return $this->db->insert_id();
    }
    public function insertcouponhistory($data) {
        date_default_timezone_set('Asia/Kolkata');
        $orderData['create_date'] = date('Y-m-d H:i:s'); 
        $this->db->insert('coupan_history', $data);
        return $this->db->insert_id();
    }

    public function updateCartSessionId($sessionId, $cartData) {
        $this->db->where('session_id', $sessionId);
        $this->db->update('cart', $cartData);
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

    public function delCartSessionId($sessionId) {
        $this->db->where('session_id', $sessionId);
        $this->db->delete('cart');
    }

    public function checkUserId($data) {
        $this->db->select('id_customer,email_id,mobile_no,full_name,address');
        $this->db->from('customer');
        $this->db->where('id_customer', $data['userID']);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function getcuswallet($customerId) {
        $this->db->select('customer_wallet');
        $this->db->from('customer');
        $this->db->where('id_customer', $customerId);
        $query = $this->db->get();
        $result = $query->result_array();
        if ($query->num_rows() > 0) {
            return round($result[0]['customer_wallet'], 2);
        } else
            return false;
    }

    public function getUserAddresses($data) {
        $this->db->select('*');
        $this->db->from('customer_address');
        $this->db->join('city', 'city.city_id = customer_address.customer_city_id');
        $this->db->where('customer_id', $data['userID']);
        $this->db->where('city_id', $this->session->userdata('city_id'));
        $this->db->order_by('address_id', 'desc');
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function getUserAddress($addId, $userId) {
        $this->db->select('*,city.city_name as cityname,city.city_id as cityid,s.city_id as stateid');
        $this->db->from('customer_address');
        $this->db->join('city', 'city.city_id = customer_address.customer_city_id');
        $this->db->join('city s', 's.city_id = city.parent_id');
        $this->db->where('customer_id', $userId);
        $this->db->where('address_id', $addId);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function orderdetails($data) {
        $this->db->select('order_id,customer_id,customer_name,delivery_address,contact_number,order_details,order_status,app_title,purchase_price,payment_txn_id,order_date_time,order_update_date');
        $this->db->from('orders o');
        $this->db->join('order_status os', 'os.id_order_status = o.order_status');
        $this->db->where('order_id', $data['orderID']);
        $this->db->where('customer_id', $data['userID']);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function checkPerviousCompletedOrderByCustomerId($userId) {
        $this->db->select('order_id,customer_id,customer_name,delivery_address,contact_number,order_details,order_status,purchase_price,payment_txn_id,order_date_time,order_update_date');
        $this->db->from('orders o');
        $this->db->where('o.order_status', 6);
        $this->db->where('customer_id', $userId);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function userorderhistory($data) {
        $this->db->select('order_id,customer_id,customer_name,delivery_address,contact_number,order_details,order_status,app_title,purchase_price,payment_txn_id,order_date_time,order_update_date');
        $this->db->from('orders o');
        $this->db->join('order_status os', 'os.id_order_status = o.order_status');
        //	$this->db->where('order_id',$data['orderID']);
        $this->db->where('customer_id', $data['userID']);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function getProductDetailsById($pid) {
        $this->db->select('product_id,product_name,product_price,product_discount as product_discount_price,product_icon');
        $this->db->from('products');
        $this->db->where('product_id', $pid);
        $query = $this->db->get();
        $result = $query->result_array()[0];
        return $result;
    }

    public function productlist($proId) {
        $this->db->select('*,products.product_id as pid');
        $this->db->from('products');
        $this->db->join('ecom_categories', 'ecom_categories.id = products.product_sub_cat_id');
        $this->db->where('products.status', '1');
        $this->db->order_by('products.product_id', 'desc');

        if ($proId)
            $this->db->where('product_id', $proId);

        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $row = $query->result_array();

            return $row;
        } else
            return false;
    }

    public function productlistfree($proId) {
        $this->db->select('*,products.product_id as pid');
        $this->db->from('products');
        $this->db->join('ecom_categories', 'ecom_categories.id = products.product_sub_cat_id');
        $this->db->order_by('products.product_id', 'desc');

        if ($proId)
            $this->db->where('product_id', $proId);

        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $row = $query->result_array();

            return $row;
        } else
            return false;
    }

    public function productlist2($proId) {
        $this->db->select('*,products.product_id as pid');
        $this->db->from('products');
        $this->db->where('products.status', '1');
        $this->db->order_by('products.product_id', 'desc');

        if ($proId)
            $this->db->where_in('product_id', $proId);

        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $row = $query->result_array();

            return $row;
        } else
            return false;
    }

    public function packagelist($proId) {
        $this->db->select('*');
        $this->db->from('package');
        $this->db->where('package_status', '1');
        $this->db->order_by('package.id_package', 'desc');

        if ($proId)
            $this->db->where('id_package', $proId);

        $query = $this->db->get();
        //	echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            $row = $query->result_array();

            return $row;
        } else
            return false;
    }

    public function gifthamperlist($proId) {
        $this->db->select('*');
        $this->db->from('gift_hampers gh');
        $this->db->where('package_status', '1');
        $this->db->order_by('gh.id_package', 'desc');

        if ($proId)
            $this->db->where('id_package', $proId);

        $query = $this->db->get();
        //	echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            $row = $query->result_array();

            return $row;
        } else
            return false;
    }

    public function checkuserById($cusId) {
        $this->db->select('*,customer.city_id as cus_city_id');
        $this->db->from('customer');
        $this->db->join('city', 'customer.city_id = city.city_id', 'left');
        $this->db->join('city_locality', 'city_locality.city_locality_id = customer.city_id', 'left');
        if ($cusId)
            $this->db->where('id_customer', $cusId);

        $query = $this->db->get();
        //	echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            $row = $query->result_array()[0];

            return $row;
        } else
            return false;
    }

    public function checkCoupon($CouponCode) {
        $this->db->select('*');
        $this->db->from('coupan');
        if ($CouponCode)
            $this->db->where('coupan_code', $CouponCode);

        $this->db->where('coupan_status', '1');
        $this->db->where('valide_to >= ', date('Y-m-d'));

        $query = $this->db->get();
        //	echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            $row = $query->result_array()[0];

            return $row;
        } else
            return false;
    }

    public function couponLists() {
        $this->db->select('*');
        $this->db->from('coupan');
        $this->db->where('coupan_status', '1');
        $this->db->where('valide_to >= ', date('Y-m-d'));
        $query = $this->db->get();
        //	echo $this->db->last_query(); die;
        if ($query->num_rows() > 0) {
            $row = $query->result_array()[0];
            return $row;
        } else
            return false;
    }

}

?>