<?php

//error_reporting(-1);

class Paymentmodel extends CI_Model {

    public function __construct() {

        parent::__construct();
    }

    public function paymentIdUpdate($orderId, $paymentId, $amount) {
        $query['appointment'] = array(
            'advance_paid' => $amount,
            'txn_id' => $paymentId
        );
        $this->db->update('hsbp_appointment', $query['appointment'], array('id_appointment' => $orderId));
        $query['appointment']['order_id'] = $orderId;
        $this->insertPaymentLeaser($query['appointment']);
        return true;
    }

    public function insertPaymentLeaser($data) {
        $data['amount'] = $data['advance_paid'];
        $data['payment_id'] = $data['txn_id'];
        unset($data['advance_paid']);
        unset($data['txn_id']);
        $this->db->insert('hsbp_payment_leaser', $data);
        return true;
    }

    public function addmoneyinwallet($data, $customerId) {
        $amount = $data['TXNAMOUNT'];
        $this->db->where("id_customer", $customerId);
        $this->db->set("customer_wallet", "`customer_wallet`+ $amount", FALSE);
        $this->db->update("customer");
        //	echo $this->db->last_query(); die;
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

    public function deductFromWallet($walletDeductAmount, $customerId) {
        $amount = $walletDeductAmount;
        $this->db->where("id_customer", $customerId);
        $this->db->set("customer_wallet", "`customer_wallet`- $amount", FALSE);
        $this->db->update("customer");
        //	echo $this->db->last_query(); die;
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }

    public function createTransaction($data, $customerId) {
        date_default_timezone_set('Asia/Kolkata');
        $arr = array(
            'user_id' => $customerId,
            'order_id' => $data['orderid'],
            'amount' => $data['amount'],
            'payment_method' => 'wallet',
            'gateway_txn_id' => 'Wallet_'.time(),
            'payment_status' => 'success',
            'mobile_no' => $data['mobileno'],
            'created_date' => date('Y-m-d H:i:s'),
        );
        $this->db->insert('user_transaction', $arr);
        return $this->db->insert_id();
    }

    public function user_transaction($data, $customerId) {
        date_default_timezone_set('Asia/Kolkata');
        if ($data['STATUS'] == 'TXN_SUCCESS') {
            $status = 'success';
        } elseif ($data['STATUS'] == 'TXN_FAILURE') {
            $status = 'failed';
        } else {
            $status = 'pending';
        }
        $arr = array(
            'user_id' => $customerId,
            'order_id' => $data['ORDERID'],
            'amount' => $data['TXNAMOUNT'],
            'payment_method' => 'online',
            'gateway_txn_id' => $data['TXNID'],
            'payment_status' => $status,
            'mobile_no' => $data['mobile_no'],
            'created_date' => date('Y-m-d H:i:s'),
        );
        $this->db->insert('user_transaction', $arr);
        return $this->db->insert_id();
    }

    public function user_wallet($data, $customerId) {

        date_default_timezone_set('Asia/Kolkata');
        $arr = array(
            'user_id' => $customerId,
            'opening_balance' => $data['opening_balance'],
            'closing_balance' => $data['closing_balance'],
            'amount' => $data['TXNAMOUNT'],
            'transaction' => 'credit',
            'purpose' => 'Add Money in Wallet',
            'transaction_id' => $data['transactionId'],
            'created_date' => date('Y-m-d H:i:s'),
        );
        $this->db->insert('user_wallet', $arr);
        return $this->db->insert_id();
    }

    public function user_wallet_debit($data, $customerId) {

        date_default_timezone_set('Asia/Kolkata');
        $arr = array(
            'user_id' => $customerId,
            'opening_balance' => $data['opening_balance'],
            'closing_balance' => $data['closing_balance'],
            'amount' => $data['TXNAMOUNT'],
            'transaction' => 'debit',
            'purpose' => 'Debit from wallet',
            'transaction_id' => $data['transactionId'],
            'created_date' => date('Y-m-d H:i:s'),
        );
        $this->db->insert('user_wallet', $arr);
        return $this->db->insert_id();
    }

    public function createsubscription($customerId, $selectedAddId) {

        date_default_timezone_set('Asia/Kolkata');
        $arr = array(
            'customer_id' => $customerId,
            'address_id' => $selectedAddId,
            'subscription_valid_date' => date('Y-m-d H:i:s', strtotime("+30 days")),
        );
        $this->db->insert('subscription', $arr);

        $this->db->where("id_customer", $customerId);
        $this->db->set("customer_prasuk_family_card", "1");
        $this->db->update("customer");
        return true;
    }

}

?>