<?php //print_r($counseling[0]['items']); ?>
<div class="container patient-prfoile">
    
    <div class="profilebox">
    
        <div class="row">
            <div class="col-md-12"><div class="proname"><?php echo $patient[0]['patient_name']; ?></div></div>
            <div class="col-md-12"><div class="sephead">Personal Information</div></div>
            
            <div class="col-md-3">
                <label>Mobile Number</label>
                <div class="labelvalue"><?php echo $patient[0]['patient_mobile']; ?></div>
            </div>
            <div class="col-md-3">
                <label>Alternative Number</label>
                <div class="labelvalue"><?php echo $patient[0]['alternative_number']; ?></div>
            </div>
            <div class="col-md-3">
                <label>Age</label>
                <div class="labelvalue"><?php echo $patient[0]['patient_age']; ?> Years</div>
            </div>
            <div class="col-md-3">
                <label>Gender</label>
                <div class="labelvalue"><?php echo $patient[0]['gender']; ?></div>
            </div>
            
            <div class="col-md-3">
                <label>Smoke Category</label>
                <div class="labelvalue"><?php echo $patient[0]['smoke_category']; ?></div>
            </div>
            
            <div class="col-md-9">
                <label>Smoke Items</label>
                <div class="labelvalue"><?php echo str_replace("]","",str_replace("[","",json_decode($patient[0]['smoke_items']))); ?></div>
            </div>
            
            <div class="col-md-8">
                <label>Alchohol</label>
                <div class="labelvalue"><?php echo $patient[0]['alchohol']; ?></div>
            </div>
            
            <div class="col-md-4">
                <label>Duration</label>
                <div class="labelvalue"><?php echo $patient[0]['alchohol_duration']; ?></div>
            </div>
            
            <div class="col-md-3">
                <label>Other Drugs?</label>
                <div class="labelvalue"><?php echo $patient[0]['other_drugs']; ?></div>
            </div>
            
            <div class="col-md-9">
                <label>Medical History</label>
                <div class="labelvalue"><?php echo $patient[0]['medical_history']; ?></div>
            </div>
        </div>
    
    </div>
    
    <?php if($patient[0]['last_schedule_date']!=null || $patient[0]['next_schedule_date']!=null) { ?>
    <div class="profilebox">
    
        <div class="row">
            
            <div class="col-md-12"><div class="sephead">Counseling Information</div></div>
            
            <?php if($patient[0]['last_schedule_date']!=null) { ?>
            <div class="col-md-6">
                <label>Last Schedule Date</label>
                <div class="labelvalue"><?php echo date('d-M-Y', strtotime($patient[0]['last_schedule_date'])); ?></div>
            </div>
            <?php } ?>
            <?php if($patient[0]['next_schedule_date']!=null) { ?>
            <div class="col-md-6">
                <label>Next Schedule Date</label>
                <div class="labelvalue"><?php echo date('d-M-Y', strtotime($patient[0]['next_schedule_date'])); ?></div>
            </div>
            <?php } ?>
            
        </div>
    
    </div>
    <?php } ?>
    
    <?php foreach($counseling as $item) { ?>
    <div class="profilebox">
    
        <div class="row">
            
            
                <div class="col-md-12"><div class="sephead">Step <?php echo $item['coun_step']; ?> on <span class="cdate"><?php echo date('d-M-Y', strtotime($item['coun_date'])); ?></span></div></div>
                <?php if(isset($item['assessment_data'])) { ?>
                <div class="col-md-12"><div class="sephead">Pre-Motivation Test Information</div></div>
                <div class="assessmentdata">
                    
                    <?php 
                    $assesmentdata=json_decode($item['assessment_data'], true);;
    
                    foreach($assesmentdata as $adata) { ?>
                        <div class="col-md-12">
                            <label style="border-bottom: 1px solid #efefef;padding: 10px 0;width:100%;"><?php echo $adata['QuestionId']; ?>. <?php echo $adata['Question']; ?> - <span class="answer"><?php echo $adata['Answer']; ?></span></label>
                        </div>
                    <?php } ?>
                    
                </div>
                <?php } ?>
            
            
                <div class="col-md-12"><div class="sephead">FNDT Assessment</div></div>
            
            
                <table width="100%" class="itemtable">
                    <thead>
                        <tr>
                            <th>Item</th>
                            <th class="text-center">Age of Initiation</th>
                            <th class="text-center">Consumption Years</th>
                            <th class="text-center">Cost per Unit</th>
                            <th class="text-center">Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total=0;
                        foreach($item['items'] as $qs) { ?>
                        <tr>
                            <td><?php echo $qs['item']; ?></td>
                            <td class="text-center"><?php echo $qs['age']; ?></td>
                            <td class="text-center"><?php echo $qs['consumption']; ?></td>
                            <td class="text-center"><?php echo $qs['cost']; ?></td>
                            <td class="text-center"><?php echo $qs['total']; ?></td>
                        </tr>
                        <?php 
                        $total=$total+$qs['total'];
                        } ?>
                        <tr>
                            <td colspan="4"></td>
                            <td class="text-center"><strong><?php echo $total; ?></strong></td>
                        </tr>
                    </tbody>
                </table>
            
                <div class="col-md-12"><div class="sephead">FNDT Questions & Answers</div></div>
            
                <?php 
                foreach($item['questions'] as $adata) { ?>
                    <div class="col-md-12">
                        <label><?php echo $adata['number']; ?>. <?php echo $adata['question']; ?></label>
                        <div class="labelvalue"><?php echo $adata['answer']; ?></div>
                    </div>
                <?php } ?>
            
            
        </div>
        
    </div>
    <?php } ?>
    
</div>

<style>
    .patient-prfoile {
        margin-top: 20px;
        border-top: 1px solid #dddddd;
        width: 100%;
        padding-top: 15px;
    }
    
    .profilebox {
        background: #fff;
        padding: 15px;
        border-radius: 10px;
        margin-bottom:15px;
    }
    
    .proname {
        font-size: 18px;
        font-weight: 700;
        text-transform:capitalize;
    }
    
    .sephead {
        margin: 15px 0 10px 0;
        font-size: 16px;
        font-weight: 600;
    }
    
    label {
        font-weight: 400;
        font-size: 15px;
        color: gray;
    }
    
    .labelvalue {
        font-size: 16px;
        margin-bottom: 20px;
    }
    
    span.cdate {
        color: #dc3540;
        margin-left: 5px;
        font-size: 16px;
    }
    
    .answer {
        float:right;
        color:#dc3540;
    }
    
    table.itemtable {
        margin: 10px 15px;
        border: 1px solid #ede4e4;
    }
    
    table.itemtable th, table.itemtable td {
        padding: 10px;
        border: 1px solid #e1e1e1;
    }
</style>