<?php

class Patientmodel extends CI_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function addPatient($data)
    {
        $userTable = array(
            'doctor_id' => $data['UserId'],
            'patient_name' => $data['Name'],
            'patient_age' => $data['Age'],
            'gender' => $data['Gender'],
            'patient_mobile' => $data['Mobile'],
            'alternative_number' => $data['AlternateMobile'],
            'marital_status' => '',/*$data['MaritalStatus'],*/
            'data' => json_encode($data['Data']),
            'occupation' => '', /*$data['Occupation']*/
            'otp' => $data['otp']
        );
        $query = $this->db->insert('patients', $userTable);
        $insert = $this->db->insert_id();
        return $insert;
    }

    public function patientOTP($data)
    {
        $this->db->select('patient_id');
        $this->db->from('ecom_patients');
        $this->db->where('patient_id', $data['PatientId']);
        $this->db->where('otp', $data['OTP']);
        $query = $this->db->get();
        //echo "<pre>";print_r($query); die;			
        return $query->result_array();
    }

    public function getPatientList($data)
    {
        $this->db->select('patient_id,patient_name,patient_mobile,count_session,last_schedule_date,next_schedule_date');
        $this->db->from('ecom_patients');
        $this->db->order_by('patient_id', 'desc');
        $this->db->where('patient_status', 1);
        $this->db->where('doctor_id', $data['UserId']);
        $this->db->where('created_date >=', date('Y-m-d', strtotime($data['StartDate'])));
        $this->db->where('created_date <', date('Y-m-d', strtotime("+1 days", strtotime($data['EndDate']))));
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->result_array();
            return $res;
        } else {
            return false;
        }
    }
    public function getTodayAppointmentList($data)
    {
        $this->db->select('patient_id,patient_name,patient_mobile,count_session,last_schedule_date,next_schedule_date');
        $this->db->from('ecom_patients');
        $this->db->order_by('patient_id', 'desc');
        $this->db->where('patient_status', 1);
        $this->db->where('doctor_id', $data['UserId']);
        $this->db->where('next_schedule_date >=', date('Y-m-d'));
        $this->db->where('next_schedule_date <', date('Y-m-d', strtotime("+1 days", strtotime(date('Y-m-d')))));
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->result_array();
            return $res;
        } else {
            return false;
        }
    }

    public function getAllPatientList($data)
    {
        $this->db->select('patient_id,patient_name,patient_mobile');
        $this->db->from('ecom_patients');
        $this->db->order_by('patient_id', 'desc');
        $this->db->where('doctor_id', $data['UserId']);
        $this->db->where('patient_status', 1);
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->result_array();
            return $res;
        } else {
            return false;
        }
    }

    public function getPatientDetail($data)
    {
        $this->db->select('pat.patient_id,pat.data,patient_name,gender,patient_age,patient_mobile,marital_status,occupation,assessment_data,assessment_data2,assessment_data3,assessment_data4,pat.count_session,pat.last_schedule_date,pat.next_schedule_date,pat.session1_data,pat.session2_data,pat.session3_data,pat.patient_status,pat.alternative_number,smoke_category,smoke_items,alchohol,alchohol_duration,other_drugs,medical_history');
        $this->db->from('ecom_patients as pat');
        $this->db->join('ecom_doc_counselings as dcc', 'dcc.patient_id = pat.patient_id', 'left');
        $this->db->where('pat.patient_id', $data['PatientId']);
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->first_row();
            return $res;
        } else {
            return false;
        }
    }
    public function checkPatientWithDoctor($data)
    {
        $this->db->select('*');
        $this->db->from('ecom_patients as pat');
        $this->db->where('pat.patient_mobile', $data['Mobile']);
        $this->db->where('pat.doctor_id', $data['UserId']); 
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->first_row();
            return $res;
        } else {
            return false;
        }
    }

    public function pushCounselAssessment($data)
    {
        $arr = array(
            'doctor_id' => $data['DoctorId'],
            'patient_id' => $data['PatientId'],
            'coun_step' => $data['CountStep'],
            'coun_date' => $data['DateTime'],
            'assessment_data' => json_encode($data['Data1']),
            'assessment_data2' => json_encode($data['Data2']),
            'assessment_data3' => json_encode($data['Data3']),
            'assessment_data4' => json_encode($data['Data4'])
        );
        if (!$data['Data1']) {
            unset($arr['assessment_data']);
        }
        if (!$data['Data2']) {
            unset($arr['assessment_data2']);
        }
        if (!$data['Data3']) {
            unset($arr['assessment_data3']);
        }
        if (!$data['Data4']) {
            unset($arr['assessment_data4']);
        }
        if (!$data['CountStep']) {
            unset($arr['coun_step']);
        }
        //print_r($arr);die;
        $query = $this->db->insert('ecom_doc_counselings', $arr);
        $insert = $this->db->insert_id();
        return $insert;
    }

    public function popCounselAssessment($data)
    {
        $this->db->select('doctor_id,patient_id,coun_step');
        $this->db->from('ecom_doc_counselings');
        $this->db->order_by('doctor_id', 'desc');
        //$this->db->where('doctor_id', $data['patient_id']);
        $query = $this->db->get();
        //echo $this->db->last_query(); die;
        if ($query->num_rows()) {
            $res = $query->result_array();
            return $res;
        } else {
            return false;
        }
    }
    public function checkCounselAssessment($PatientId, $DoctorId)
    {
        $this->db->select('doctor_id,patient_id,coun_step');
        $this->db->from('ecom_doc_counselings');
        $this->db->where('patient_id', $PatientId);
        $this->db->where('doctor_id', $DoctorId);
        $query = $this->db->get();
        if ($query->num_rows()) {
            $res = $query->result_array();
            return $res;
        } else {
            return false;
        }
    }

    public function updatePushCounselAssessment($arr, $PatientId, $DoctorId)
    {
        $this->db->where('patient_id', $PatientId);
        $this->db->where('doctor_id', $DoctorId);
        $query = $this->db->update('ecom_doc_counselings', $arr);
        if ($this->db->affected_rows()) {
            return true;
        }
        return false;
    }
    public function UpdatePatientSession($arr, $inputData)
    {
        $this->db->where('patient_id', $inputData['PatientId']);
        $this->db->where('doctor_id', $inputData['DoctorId']);
        $query = $this->db->update('ecom_patients', $arr);
        //echo $this->db->last_query(); die;
        return true;
    }
    public function UpdateStatus($id)
    {
        $arr = [
            'patient_status' => 1
        ];
        $this->db->where('patient_id', $id);
        $query = $this->db->update('ecom_patients', $arr);
        //echo $this->db->last_query(); die;
        return true;
    }
    public function UpdatePatient($data, $id)
    {
        $this->db->where('patient_id', $id);
        $query = $this->db->update('ecom_patients', $data);
        return true;
    }
}
